/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.handler.MultiStepControlHandler;

@ParametersAreNonnullByDefault
public class MultiStepControlPanel
extends JPanel
implements MultiStepControlHandler.MultiStepControlService {
    private final ResourceBundle resourceBundle;
    private MultiStepControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton cancelButton;
    private JButton finishButton;
    private JButton nextButton;
    private JButton previousButton;

    public MultiStepControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(MultiStepControlPanel.class));
    }

    public MultiStepControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.okCancelListener = new OkCancelListener(){

            @Override
            public void okEvent() {
                MultiStepControlPanel.this.performClick(MultiStepControlHandler.ControlActionType.FINISH);
            }

            @Override
            public void cancelEvent() {
                MultiStepControlPanel.this.performClick(MultiStepControlHandler.ControlActionType.CANCEL);
            }
        };
    }

    public void setHandler(MultiStepControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.finishButton = new JButton();
        this.nextButton = new JButton();
        this.previousButton = new JButton();
        this.cancelButton = new JButton();
        this.finishButton.setText(this.resourceBundle.getString("finishButton.text"));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiStepControlPanel.this.finishButtonActionPerformed(evt);
            }
        });
        this.nextButton.setText(this.resourceBundle.getString("nextButton.text"));
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiStepControlPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.previousButton.setText(this.resourceBundle.getString("previousButton.text"));
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiStepControlPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiStepControlPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.previousButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.finishButton).addComponent(this.nextButton).addComponent(this.previousButton)).addContainerGap()));
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(MultiStepControlHandler.ControlActionType.FINISH);
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(MultiStepControlHandler.ControlActionType.NEXT);
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(MultiStepControlHandler.ControlActionType.PREVIOUS);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed(MultiStepControlHandler.ControlActionType.CANCEL);
        }
    }

    @Override
    public void performClick(MultiStepControlHandler.ControlActionType actionType) {
        switch (actionType) {
            case FINISH: {
                UiUtils.doButtonClick(this.finishButton);
                break;
            }
            case CANCEL: {
                UiUtils.doButtonClick(this.cancelButton);
                break;
            }
            case NEXT: {
                UiUtils.doButtonClick(this.nextButton);
                break;
            }
            case PREVIOUS: {
                UiUtils.doButtonClick(this.previousButton);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal action type " + actionType.name());
            }
        }
    }

    @Override
    @Nonnull
    public JButton getDefaultButton() {
        return this.finishButton;
    }

    @Override
    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    @Override
    @Nonnull
    public MultiStepControlHandler.MultiStepControlEnablementListener createEnablementListener() {
        return (actionType, enablement) -> {
            switch (actionType) {
                case FINISH: {
                    this.finishButton.setEnabled(enablement);
                    break;
                }
                case CANCEL: {
                    this.cancelButton.setEnabled(enablement);
                    break;
                }
                case NEXT: {
                    this.nextButton.setEnabled(enablement);
                    break;
                }
                case PREVIOUS: {
                    this.previousButton.setEnabled(enablement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal action type " + actionType.name());
                }
            }
        };
    }
}

