/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LanguageUtils {
    private static ClassLoader languageClassLoader = null;

    private LanguageUtils() {
    }

    @Nullable
    public static ClassLoader getLanguageClassLoader() {
        return languageClassLoader;
    }

    public static void setLanguageClassLoader(ClassLoader languageClassLoader) {
        LanguageUtils.languageClassLoader = languageClassLoader;
    }

    @Nonnull
    public static String getClassNamePath(Class<?> targetClass) {
        return targetClass.getCanonicalName().replace(".", "/");
    }

    @Nonnull
    public static ResourceBundle getResourceBundleByClass(Class<?> targetClass) {
        if (languageClassLoader == null) {
            return ResourceBundle.getBundle(LanguageUtils.getResourceBaseNameBundleByClass(targetClass));
        }
        return new LanguageResourceBundle(LanguageUtils.getResourceBaseNameBundleByClass(targetClass));
    }

    @Nonnull
    public static String getResourceBaseNameBundleByClass(Class<?> targetClass) {
        String classNamePath = LanguageUtils.getClassNamePath(targetClass);
        int classNamePos = classNamePath.lastIndexOf("/");
        return classNamePath.substring(0, classNamePos + 1) + "resources" + classNamePath.substring(classNamePos);
    }

    @ParametersAreNonnullByDefault
    private static class LanguageResourceBundle
    extends ResourceBundle {
        private final ResourceBundle mainResourceBundle;
        private final ResourceBundle languageResourceBundle;

        public LanguageResourceBundle(String baseName) {
            this.mainResourceBundle = ResourceBundle.getBundle(baseName);
            this.languageResourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), languageClassLoader);
        }

        @Override
        @Nullable
        protected Object handleGetObject(String key) {
            Object object = this.languageResourceBundle.getObject(key);
            if (object == null) {
                object = this.mainResourceBundle.getObject(key);
            }
            return object;
        }

        @Override
        @Nonnull
        public Enumeration<String> getKeys() {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(Collections.list(this.languageResourceBundle.getKeys()));
            keys.addAll(Collections.list(this.mainResourceBundle.getKeys()));
            return Collections.enumeration(keys);
        }
    }
}

