/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;

@ParametersAreNonnullByDefault
public class ActionUtils {
    public static final String DIALOG_MENUITEM_EXT = "...";
    public static final String ACTION_TYPE = "type";
    public static final String ACTION_RADIO_GROUP = "radioGroup";
    public static final String ACTION_DIALOG_MODE = "dialogMode";
    public static final String ACTION_MENU_CREATION = "menu_creation";
    public static final String ACTION_ID = "actionId";
    public static final String ACTION_NAME_POSTFIX = ".text";
    public static final String ACTION_SHORT_DESCRIPTION_POSTFIX = ".shortDescription";
    public static final String ACTION_SMALL_ICON_POSTFIX = ".smallIcon";
    public static final String ACTION_SMALL_LARGE_POSTFIX = ".largeIcon";
    public static final String CYCLE_POPUP_MENU = "cyclePopupMenu";

    private ActionUtils() {
    }

    public static void setupAction(Action action, ResourceBundle bundle, String actionId) {
        ActionUtils.setupAction(action, bundle, action.getClass(), actionId);
    }

    public static void setupAction(Action action, ResourceBundle bundle, Class<?> resourceClass, String actionId) {
        action.putValue("Name", bundle.getString(actionId + ACTION_NAME_POSTFIX));
        action.putValue(ACTION_ID, actionId);
        if (bundle.containsKey(actionId + ACTION_SHORT_DESCRIPTION_POSTFIX)) {
            action.putValue("ShortDescription", bundle.getString(actionId + ACTION_SHORT_DESCRIPTION_POSTFIX));
        }
        if (bundle.containsKey(actionId + ACTION_SMALL_ICON_POSTFIX)) {
            action.putValue("SmallIcon", new ImageIcon(resourceClass.getResource(bundle.getString(actionId + ACTION_SMALL_ICON_POSTFIX))));
        }
        if (bundle.containsKey(actionId + ACTION_SMALL_LARGE_POSTFIX)) {
            action.putValue("SwingLargeIconKey", new ImageIcon(resourceClass.getResource(bundle.getString(actionId + ACTION_SMALL_LARGE_POSTFIX))));
        }
    }

    public static int getMetaMask() {
        try {
            switch (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                case 2: {
                    return 128;
                }
                case 4: {
                    return 256;
                }
                case 1: {
                    return 64;
                }
                case 8: {
                    return 512;
                }
            }
            return 128;
        }
        catch (HeadlessException ex) {
            return 128;
        }
    }

    public static void invokeTextAction(JTextComponent textComponent, String actionName) {
        ActionMap textActionMap = textComponent.getActionMap().getParent();
        long eventTime = EventQueue.getMostRecentEventTime();
        int eventMods = ActionUtils.getCurrentEventModifiers();
        ActionEvent actionEvent = new ActionEvent(textComponent, 1001, actionName, eventTime, eventMods);
        textActionMap.get(actionName).actionPerformed(actionEvent);
    }

    @Nonnull
    public static JMenuItem actionToMenuItem(Action action) {
        return ActionUtils.actionToMenuItem(action, null);
    }

    @Nonnull
    public static JMenuItem actionToMenuItem(Action action, @Nullable Map<String, ButtonGroup> buttonGroups) {
        Object dialogMode;
        JMenuItem menuItem;
        block8: {
            block7: {
                ActionType actionType = (ActionType)((Object)action.getValue(ACTION_TYPE));
                if (actionType == null) break block7;
                switch (actionType) {
                    case CHECK: {
                        menuItem = new JCheckBoxMenuItem(action);
                        break;
                    }
                    case RADIO: {
                        menuItem = new JRadioButtonMenuItem(action);
                        String radioGroup = (String)action.getValue(ACTION_RADIO_GROUP);
                        if (buttonGroups != null) {
                            ButtonGroup buttonGroup = buttonGroups.get(radioGroup);
                            if (buttonGroup == null) {
                                buttonGroup = new ButtonGroup();
                                buttonGroups.put(radioGroup, buttonGroup);
                            }
                            buttonGroup.add(menuItem);
                            break;
                        }
                        break block8;
                    }
                    default: {
                        menuItem = new JMenuItem(action);
                        break;
                    }
                }
                break block8;
            }
            menuItem = new JMenuItem(action);
        }
        if ((dialogMode = action.getValue(ACTION_DIALOG_MODE)) instanceof Boolean && ((Boolean)dialogMode).booleanValue()) {
            menuItem.setText(menuItem.getText() + DIALOG_MENUITEM_EXT);
        }
        return menuItem;
    }

    private static int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiersEx();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    public static enum ActionType {
        PUSH,
        CHECK,
        RADIO,
        CYCLE;

    }

    @ParametersAreNonnullByDefault
    public static interface MenuCreation {
        public boolean shouldCreate(String var1);

        public void onCreate(JMenuItem var1, String var2);
    }
}

