/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXDesc;
import org.exbin.xbup.catalog.entity.manager.XBEXDescManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.manager.XBCXDescManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXLangManager;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBEXDescService
extends XBEDefaultService<XBCXDesc>
implements XBCXDescService,
Serializable {
    @Autowired
    private XBEXDescManager manager;

    public XBEXDescService() {
    }

    public XBEXDescService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBEXDescManager(catalog);
        catalog.addCatalogManager(XBCXDescManager.class, (XBCXDescManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public XBEXDesc getDefaultItemDesc(XBCItem item) {
        return ((XBEXDescManager)this.itemManager).getDefaultItemDesc(item);
    }

    public XBEXDesc getItemDesc(XBCItem item, XBCXLanguage language) {
        return ((XBEXDescManager)this.itemManager).getItemDesc(item, language);
    }

    public List<XBCXDesc> getItemDescs(XBCItem item) {
        return ((XBEXDescManager)this.itemManager).getItemDescs(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public String getDefaultText(XBCItem item) {
        return ((XBEXDescManager)this.itemManager).getDefaultText(item);
    }

    public void setDefaultText(XBCItem item, String text) {
        XBEXDesc desc = this.getDefaultItemDesc(item);
        if (text == null || text.isEmpty()) {
            if (desc != null) {
                this.removeItem(desc);
            }
        } else {
            if (desc == null) {
                XBCXLangManager langManager = this.catalog.getCatalogManager(XBCXLangManager.class);
                desc = (XBEXDesc)this.createItem();
                desc.setItem(item);
                desc.setLang(langManager.getDefaultLang());
            }
            desc.setText(text);
            this.persistItem(desc);
        }
    }
}

