/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.manager.XBENodeManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.manager.XBCNodeManager;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBENodeService
extends XBEDefaultService<XBCNode>
implements XBCNodeService,
Serializable {
    @Autowired
    private XBENodeManager manager;

    public XBENodeService() {
    }

    public XBENodeService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBENodeManager(catalog);
        catalog.addCatalogManager(XBCNodeManager.class, (XBCNodeManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    @Nonnull
    public Optional<XBCNode> getMainRootNode() {
        return ((XBENodeManager)this.itemManager).getMainRootNode();
    }

    public Long findMaxSubNodeXB(XBCNode node) {
        return ((XBENodeManager)this.itemManager).findMaxSubNodeXB(node);
    }

    public XBENode findNodeByXBPath(Long[] catalogPath) {
        return ((XBENodeManager)this.itemManager).findNodeByXBPath(catalogPath);
    }

    public XBENode findOwnerByXBPath(Long[] catalogPath) {
        return ((XBENodeManager)this.itemManager).findOwnerByXBPath(catalogPath);
    }

    public XBENode findParentByXBPath(Long[] catalogPath) {
        return ((XBENodeManager)this.itemManager).findParentByXBPath(catalogPath);
    }

    public Long[] getNodeXBPath(XBCNode node) {
        return ((XBENodeManager)this.itemManager).getNodeXBPath(node);
    }

    public XBENode getSubNode(XBCNode node, long xbIndex) {
        return ((XBENodeManager)this.itemManager).getSubNode(node, xbIndex);
    }

    public XBENode getSubNodeSeq(XBCNode node, long seq) {
        return ((XBENodeManager)this.itemManager).getSubNodeSeq(node, seq);
    }

    public List<XBCNode> getSubNodes(XBCNode node) {
        return ((XBENodeManager)this.itemManager).getSubNodes(node);
    }

    public long getSubNodesCount(XBCNode node) {
        return ((XBENodeManager)this.itemManager).getSubNodesCount(node);
    }

    public long getSubNodesSeq(XBCNode node) {
        return ((XBENodeManager)this.itemManager).getSubNodesSeq(node);
    }

    public void removeNodeFully(XBCNode node) {
        ((XBENodeManager)this.itemManager).removeNodeFully(node);
    }
}

