/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.XBESpec;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.manager.XBCRevManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBERevManager
extends XBEDefaultCatalogManager<XBCRev>
implements XBCRevManager,
Serializable {
    public XBERevManager() {
    }

    public XBERevManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBERev.class;
    }

    public XBERev findRevByXB(XBCSpec spec, long xbIndex) {
        if (spec == null) {
            return null;
        }
        try {
            return (XBERev)this.em.createQuery("SELECT object(o) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBERev getRev(XBCSpec spec, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBERev)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long findMaxRevXB(XBCSpec spec) {
        try {
            return (Long)this.em.createQuery("SELECT MAX(o.xbIndex) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getRevsCount(XBCSpec spec) {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getRevsLimitSum(XBCSpec spec, long revision) {
        try {
            return (Long)this.em.createQuery("SELECT sum(o.xbLimit) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId() + " AND o.xbIndex <= " + revision).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public List<XBCRev> getRevs(XBCSpec spec) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBRev as o WHERE o.parent.id = " + ((XBESpec)spec).getId()).getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBERevManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

