/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.manager.XBCManager;

@ParametersAreNonnullByDefault
public abstract class XBEDefaultManager<T extends XBCBase>
implements XBCManager<T> {
    @PersistenceContext
    protected EntityManager em;

    public XBEDefaultManager() {
    }

    public XBEDefaultManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Nonnull
    public T createItem() {
        try {
            return (T)((XBCBase)this.getEntityClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to create new item", ex);
        }
    }

    public void removeItem(T item) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            if (!transaction.isActive()) {
                transaction.begin();
            }
        }
        catch (IllegalStateException ex) {
            Logger.getLogger(XBEDefaultManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        XBCBase removedItem = (XBCBase)this.em.merge(item);
        this.em.remove((Object)removedItem);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    @Nonnull
    public List<T> getAllItems() {
        try {
            List result = this.em.createQuery("SELECT object(o) FROM " + this.getTableName() + " as o").getResultList();
            return result;
        }
        catch (NoResultException ex) {
            return Collections.emptyList();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEDefaultManager.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public Optional<T> getItem(long itemId) {
        Object result = this.em.find(this.getEntityClass(), (Object)itemId);
        return Optional.ofNullable((XBCBase)result);
    }

    public long getItemsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM " + this.getTableName() + " as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEDefaultManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public void persistItem(T item) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            if (!transaction.isActive()) {
                transaction.begin();
            }
        }
        catch (IllegalStateException ex) {
            Logger.getLogger(XBEDefaultManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.em.persist(item);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    @Nonnull
    public abstract Class getEntityClass();

    @Nonnull
    public String getTableName() {
        Class entityClass = this.getEntityClass();
        Entity annotation = entityClass.getAnnotation(Entity.class);
        if (annotation != null) {
            return annotation.name();
        }
        return entityClass.getSimpleName();
    }

    public void setItemId(T item, long itemId) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            if (!transaction.isActive()) {
                transaction.begin();
            }
        }
        catch (IllegalStateException ex) {
            Logger.getLogger(XBEDefaultManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.em.createQuery("UPDATE " + this.getTableName() + " SET id = " + itemId + " WHERE id = " + item.getId());
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    public boolean initCatalog() {
        return true;
    }
}

