/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.CompoundOperation;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.basic.XBBasicOperationType;

@ParametersAreNonnullByDefault
public class XBTCompoundBlockOperation
extends XBTDocOperation
implements CompoundOperation {
    private final List<Operation> operations = new ArrayList<Operation>();

    public XBTCompoundBlockOperation(XBTEditableDocument document) {
        super(document);
    }

    public XBTCompoundBlockOperation(XBTEditableDocument document, Collection<Operation> initialOperations) {
        super(document);
        this.operations.addAll(initialOperations);
    }

    @Override
    @Nonnull
    public XBBasicOperationType getBasicType() {
        return XBBasicOperationType.MODIFY_BLOCK;
    }

    @Override
    public void execute() throws Exception {
        for (Operation operation : this.operations) {
            operation.execute();
        }
    }

    @Override
    @Nonnull
    public Optional<Operation> executeWithUndo() throws Exception {
        LinkedList<Operation> undoOperations = new LinkedList<Operation>();
        for (Operation operation : this.operations) {
            Optional<Operation> childOperation = operation.executeWithUndo();
            if (!childOperation.isPresent()) continue;
            undoOperations.add(0, childOperation.get());
        }
        return Optional.of(new XBTCompoundBlockOperation(this.document, undoOperations));
    }

    @Override
    public void appendOperation(Operation operation) {
        this.operations.add(operation);
    }

    @Override
    public void appendOperations(Collection<Operation> appendedOperations) {
        this.operations.addAll(appendedOperations);
    }

    @Override
    @Nonnull
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public void setData(XBData data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Nonnull
    public XBData getData() {
        XBData newData = new XBData();
        int position = 0;
        for (Operation operation : this.operations) {
            XBData operationData = ((XBTDocOperation)operation).getData();
            newData.insert((long)position, (BinaryData)operationData);
            position = (int)((long)position + operationData.getDataSize());
        }
        return newData;
    }
}

