/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.MultiEditorPopupMenu;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class CloseOtherFileAction
extends AbstractAction
implements FileDependentAction {
    public static final String ACTION_ID = "fileCloseOtherAction";
    private ResourceBundle resourceBundle;
    private XBApplication application;
    private MultiEditorProvider editorProvider;

    public void setup(XBApplication application, ResourceBundle resourceBundle, MultiEditorProvider editorProvider) {
        this.application = application;
        this.resourceBundle = resourceBundle;
        this.editorProvider = editorProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.updateForActiveFile();
    }

    public void updateForActiveFile() {
        Optional activeFile = this.editorProvider.getActiveFile();
        this.setEnabled(activeFile.isPresent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MultiEditorPopupMenu popupMenu;
        Object source = e.getSource();
        MultiEditorPopupMenu multiEditorPopupMenu = popupMenu = source instanceof JMenuItem && ((JMenuItem)source).getParent() instanceof MultiEditorPopupMenu ? (MultiEditorPopupMenu)((JMenuItem)source).getParent() : null;
        if (popupMenu != null) {
            Optional selectedFile = popupMenu.getSelectedFile();
            if (selectedFile.isPresent()) {
                this.editorProvider.closeOtherFiles((FileHandler)selectedFile.get());
            }
        } else {
            Optional activeFile = this.editorProvider.getActiveFile();
            this.editorProvider.closeOtherFiles((FileHandler)activeFile.get());
        }
    }
}

