/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.action.CloseAllFileAction;
import org.exbin.framework.editor.action.CloseFileAction;
import org.exbin.framework.editor.action.CloseOtherFileAction;
import org.exbin.framework.editor.action.EditorActions;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileOperations;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.operation.undo.api.UndoFileHandler;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class EditorModule
implements EditorModuleApi {
    private XBApplication application;
    private final List<EditorProvider> editors = new ArrayList<EditorProvider>();
    private final Map<String, List<EditorProvider>> pluginEditorsMap = new HashMap<String, List<EditorProvider>>();
    private EditorProvider editorProvider = null;
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener = null;
    private ResourceBundle resourceBundle;
    private CloseFileAction closeFileAction;
    private CloseAllFileAction closeAllFileAction;
    private CloseOtherFileAction closeOtherFileAction;
    private EditorActions editorActions;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(EditorModule.class);
        }
        return this.resourceBundle;
    }

    private void ensureSetup() {
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    private void setEditorProvider(final EditorProvider editorProvider) {
        if (this.editorProvider == null) {
            ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
            actionModule.registerClipboardHandler(new ClipboardActionsHandler(){

                public void performCut() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        ((ClipboardActionsHandler)fileHandler).performCut();
                    }
                }

                public void performCopy() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        ((ClipboardActionsHandler)fileHandler).performCopy();
                    }
                }

                public void performPaste() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        ((ClipboardActionsHandler)fileHandler).performPaste();
                    }
                }

                public void performDelete() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        ((ClipboardActionsHandler)fileHandler).performDelete();
                    }
                }

                public void performSelectAll() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        ((ClipboardActionsHandler)fileHandler).performSelectAll();
                    }
                }

                public boolean isSelection() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        return ((ClipboardActionsHandler)fileHandler).isSelection();
                    }
                    return false;
                }

                public boolean isEditable() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        return ((ClipboardActionsHandler)fileHandler).isEditable();
                    }
                    return false;
                }

                public boolean canSelectAll() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        return ((ClipboardActionsHandler)fileHandler).canSelectAll();
                    }
                    return false;
                }

                public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
                    EditorModule.this.clipboardActionsUpdateListener = updateListener;
                }

                public boolean canPaste() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        return ((ClipboardActionsHandler)fileHandler).canPaste();
                    }
                    return true;
                }

                public boolean canDelete() {
                    FileHandler fileHandler = editorProvider.getActiveFile().orElse(null);
                    if (fileHandler instanceof ClipboardActionsHandler) {
                        return ((ClipboardActionsHandler)fileHandler).canDelete();
                    }
                    return this.isEditable();
                }
            });
        }
        this.editorProvider = editorProvider;
    }

    public void unregisterModule(String moduleId) {
        List<EditorProvider> pluginEditors = this.pluginEditorsMap.get(moduleId);
        if (pluginEditors != null) {
            for (EditorProvider editor : pluginEditors) {
                this.editors.remove(editor);
            }
            this.pluginEditorsMap.remove(moduleId);
        }
    }

    public void registerEditor(String pluginId, EditorProvider editorProvider) {
        if (editorProvider instanceof UndoActionsHandler) {
            ((UndoActionsHandler)editorProvider).setUndoUpdateListener(() -> {
                OperationUndoModuleApi undoModule = (OperationUndoModuleApi)this.application.getModuleRepository().getModuleByInterface(OperationUndoModuleApi.class);
                undoModule.updateUndoStatus();
            });
        }
        if (editorProvider instanceof ClipboardActionsHandler) {
            ((ClipboardActionsHandler)editorProvider).setUpdateListener(() -> {
                if (editorProvider == this.editorProvider && this.clipboardActionsUpdateListener != null) {
                    this.clipboardActionsUpdateListener.stateChanged();
                }
            });
        }
        this.editors.add(editorProvider);
        List<EditorProvider> pluginEditors = this.pluginEditorsMap.get(pluginId);
        if (pluginEditors == null) {
            pluginEditors = new ArrayList<EditorProvider>();
            this.pluginEditorsMap.put(pluginId, pluginEditors);
        }
        pluginEditors.add(editorProvider);
        this.setEditorProvider(editorProvider);
    }

    @Nonnull
    public JComponent getEditorComponent() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.setFileOperations((FileOperations)this.editorProvider);
        return this.editorProvider.getEditorComponent();
    }

    public void registerUndoHandler() {
        OperationUndoModuleApi undoModule = (OperationUndoModuleApi)this.application.getModuleRepository().getModuleByInterface(OperationUndoModuleApi.class);
        if (this.editorProvider instanceof UndoFileHandler) {
            undoModule.setUndoHandler(((UndoFileHandler)this.editorProvider).getUndoHandler());
        }
    }

    public void registerMenuFileCloseActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.FILE_MENU_ID, new MenuGroup(FileModuleApi.FILE_MENU_GROUP_ID, new MenuPosition(PositionMode.TOP)));
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getCloseFileAction(), new MenuPosition(FileModuleApi.FILE_MENU_GROUP_ID));
    }

    @Nonnull
    public CloseFileAction getCloseFileAction() {
        if (this.closeFileAction == null) {
            this.closeFileAction = new CloseFileAction();
            this.ensureSetup();
            this.closeFileAction.setup(this.application, this.resourceBundle, (MultiEditorProvider)this.editorProvider);
        }
        return this.closeFileAction;
    }

    @Nonnull
    public CloseAllFileAction getCloseAllFileAction() {
        if (this.closeAllFileAction == null) {
            this.closeAllFileAction = new CloseAllFileAction();
            this.ensureSetup();
            this.closeAllFileAction.setup(this.application, this.resourceBundle, (MultiEditorProvider)this.editorProvider);
        }
        return this.closeAllFileAction;
    }

    @Nonnull
    public CloseOtherFileAction getCloseOtherFileAction() {
        if (this.closeOtherFileAction == null) {
            this.closeOtherFileAction = new CloseOtherFileAction();
            this.ensureSetup();
            this.closeOtherFileAction.setup(this.application, this.resourceBundle, (MultiEditorProvider)this.editorProvider);
        }
        return this.closeOtherFileAction;
    }

    @Nonnull
    public EditorActions getEditorActions() {
        if (this.editorActions == null) {
            this.editorActions = new EditorActions();
            this.ensureSetup();
            this.editorActions.setup(this.application, this.resourceBundle, (MultiEditorProvider)this.editorProvider);
        }
        return this.editorActions;
    }

    public void updateActionStatus() {
        FileDependentAction[] fileDepActions = new FileDependentAction[]{this.closeFileAction, this.closeAllFileAction, this.closeOtherFileAction};
        for (int i = 0; i < fileDepActions.length; ++i) {
            FileDependentAction fileDepAction = fileDepActions[i];
            if (fileDepAction == null) continue;
            fileDepAction.updateForActiveFile();
        }
    }
}

