/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.popup.handler;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;

@ParametersAreNonnullByDefault
public class TextComponentPopupHandler
implements ClipboardActionsHandler {
    private final JTextComponent txtComp;

    public TextComponentPopupHandler(JTextComponent txtComp) {
        this.txtComp = txtComp;
    }

    public void performCut() {
        this.txtComp.cut();
    }

    public void performCopy() {
        this.txtComp.copy();
    }

    public void performPaste() {
        this.txtComp.paste();
    }

    public void performDelete() {
        ActionUtils.invokeTextAction((JTextComponent)this.txtComp, (String)"delete-next");
    }

    public void performSelectAll() {
        SwingUtilities.invokeLater(() -> {
            this.txtComp.requestFocus();
            ActionUtils.invokeTextAction((JTextComponent)this.txtComp, (String)"select-all");
            int docLength = this.txtComp.getDocument().getLength();
            if (this.txtComp.getSelectionStart() > 0 || this.txtComp.getSelectionEnd() != docLength) {
                this.txtComp.selectAll();
            }
        });
    }

    public boolean isSelection() {
        return this.txtComp.isEnabled() && this.txtComp.getSelectionStart() != this.txtComp.getSelectionEnd();
    }

    public boolean isEditable() {
        return this.txtComp.isEnabled() && this.txtComp.isEditable();
    }

    public boolean canSelectAll() {
        return this.txtComp.isEnabled() && !this.txtComp.getText().isEmpty();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }

    public boolean canPaste() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }
}

