/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.popup.handler;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.exbin.framework.popup.ImageActionsHandler;
import org.exbin.framework.popup.LinkActionsHandler;
import org.exbin.framework.popup.PositionImageActionsHandler;
import org.exbin.framework.popup.PositionLinkActionsHandler;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.framework.utils.DesktopUtils;

@ParametersAreNonnullByDefault
public class EditorPanePopupHandler
implements ClipboardActionsHandler,
LinkActionsHandler,
PositionLinkActionsHandler,
ImageActionsHandler,
PositionImageActionsHandler {
    private static String MAP_PROPERTY = "__MAP__";
    private static String IMAGE_CACHE_PROPERTY = "imageCache";
    private final JEditorPane editorPane;

    public EditorPanePopupHandler(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    public void performCut() {
        this.editorPane.cut();
    }

    public void performCopy() {
        this.editorPane.copy();
    }

    public void performPaste() {
        this.editorPane.paste();
    }

    public void performDelete() {
        ActionUtils.invokeTextAction((JTextComponent)this.editorPane, (String)"delete-next");
    }

    public void performSelectAll() {
        this.editorPane.requestFocusInWindow();
        this.editorPane.selectAll();
    }

    public boolean isSelection() {
        return this.editorPane.isEnabled() && this.editorPane.getSelectionStart() != this.editorPane.getSelectionEnd();
    }

    public boolean isEditable() {
        return this.editorPane.isEnabled() && this.editorPane.isEditable();
    }

    public boolean canSelectAll() {
        return this.editorPane.isEnabled() && !this.editorPane.getText().isEmpty();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }

    public boolean canPaste() {
        return this.isEditable();
    }

    public boolean canDelete() {
        return this.isEditable();
    }

    @Override
    public boolean isLinkSelected() {
        return EditorPanePopupHandler.getLinkUrl(this.editorPane, this.editorPane.getCaretPosition()) != null;
    }

    @Override
    public boolean isLinkSelected(Point locationOnScreen) {
        SwingUtilities.convertPointFromScreen(locationOnScreen, this.editorPane);
        return EditorPanePopupHandler.getLinkUrl(this.editorPane, locationOnScreen) != null;
    }

    @Override
    public boolean isImageSelected() {
        return EditorPanePopupHandler.hasImageSrc(this.editorPane, this.editorPane.getCaretPosition()) != null;
    }

    @Override
    public boolean isImageSelected(Point locationOnScreen) {
        SwingUtilities.convertPointFromScreen(locationOnScreen, this.editorPane);
        return EditorPanePopupHandler.hasImageSrc(this.editorPane, locationOnScreen) != null;
    }

    @Override
    public void performCopyLink() {
        String url = EditorPanePopupHandler.getLinkUrl(this.editorPane, this.editorPane.getCaretPosition());
        StringSelection stringSelection = new StringSelection(url);
        ClipboardUtils.getClipboard().setContents(stringSelection, stringSelection);
    }

    @Override
    public void performOpenLink() {
        String url = EditorPanePopupHandler.getLinkUrl(this.editorPane, this.editorPane.getCaretPosition());
        DesktopUtils.openDesktopURL((String)url);
    }

    @Override
    public void performCopyLink(Point locationOnScreen) {
        SwingUtilities.convertPointFromScreen(locationOnScreen, this.editorPane);
        String url = EditorPanePopupHandler.getLinkUrl(this.editorPane, locationOnScreen);
        StringSelection stringSelection = new StringSelection(url);
        ClipboardUtils.getClipboard().setContents(stringSelection, stringSelection);
    }

    @Override
    public void performOpenLink(Point locationOnScreen) {
        SwingUtilities.convertPointFromScreen(locationOnScreen, this.editorPane);
        String url = EditorPanePopupHandler.getLinkUrl(this.editorPane, locationOnScreen);
        DesktopUtils.openDesktopURL((String)url);
    }

    @Override
    public void performCopyImage() {
        String imageSrc = EditorPanePopupHandler.hasImageSrc(this.editorPane, this.editorPane.getCaretPosition());
        if (imageSrc != null) {
            EditorPanePopupHandler.copyImageToClipboard((HTMLDocument)this.editorPane.getDocument(), imageSrc);
        }
    }

    @Override
    public void performCopyImage(Point locationOnScreen) {
        SwingUtilities.convertPointFromScreen(locationOnScreen, this.editorPane);
        String imageSrc = EditorPanePopupHandler.hasImageSrc(this.editorPane, locationOnScreen);
        if (imageSrc != null) {
            EditorPanePopupHandler.copyImageToClipboard((HTMLDocument)this.editorPane.getDocument(), imageSrc);
        }
    }

    @Nullable
    public static String getLinkUrl(JEditorPane editorPane, int caretPosition) {
        return EditorPanePopupHandler.getLinkUrl(editorPane, caretPosition, 0, 0);
    }

    @Nullable
    public static String getLinkUrl(JEditorPane editorPane, Point position) {
        int pos;
        Document document = editorPane.getDocument();
        if (document instanceof HTMLDocument && (pos = editorPane.viewToModel(position)) >= 0) {
            return EditorPanePopupHandler.getLinkUrl(editorPane, pos, position.x, position.y);
        }
        return null;
    }

    @Nullable
    public static String getLinkUrl(JEditorPane editorPane, int caretPosition, int offsetX, int offsetY) {
        Document document = editorPane.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument htmlDocument = (HTMLDocument)document;
            Element e = htmlDocument.getCharacterElement(caretPosition);
            AttributeSet a = e.getAttributes();
            AttributeSet anchor = (AttributeSet)a.getAttribute(HTML.Tag.A);
            if (anchor == null) {
                Object useMap = a.getAttribute(HTML.Attribute.USEMAP);
                if (useMap != null && useMap instanceof String) {
                    Object map = null;
                    Object maps = htmlDocument.getProperty(MAP_PROPERTY);
                    if (maps != null && maps instanceof Hashtable) {
                        map = ((Hashtable)maps).get((String)useMap);
                    }
                    if (map != null && caretPosition < htmlDocument.getLength()) {
                        Rectangle bounds;
                        TextUI ui = editorPane.getUI();
                        try {
                            Rectangle lBounds = ui.modelToView(editorPane, caretPosition, Position.Bias.Forward);
                            Rectangle rBounds = ui.modelToView(editorPane, caretPosition + 1, Position.Bias.Backward);
                            bounds = lBounds.getBounds();
                            bounds.add(rBounds instanceof Rectangle ? rBounds : rBounds.getBounds());
                        }
                        catch (BadLocationException ble) {
                            bounds = null;
                        }
                        if (bounds != null) {
                            Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                            try {
                                Method method = map.getClass().getMethod("getArea", paramTypes);
                                AttributeSet area = (AttributeSet)method.invoke(null, bounds.x + offsetX, bounds.y + offsetY, bounds.width, bounds.height);
                                if (area != null) {
                                    return (String)area.getAttribute(HTML.Attribute.HREF);
                                }
                            }
                            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                                Logger.getLogger(EditorPanePopupHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                return null;
            }
            String href = (String)anchor.getAttribute(HTML.Attribute.HREF);
            return href;
        }
        return null;
    }

    @Nullable
    public static String hasImageSrc(JEditorPane editorPane, int caretPosition) {
        return EditorPanePopupHandler.hasImageSrc(editorPane, caretPosition, 0, 0);
    }

    @Nullable
    public static String hasImageSrc(JEditorPane editorPane, Point position) {
        int pos;
        Document document = editorPane.getDocument();
        if (document instanceof HTMLDocument && (pos = editorPane.viewToModel(position)) >= 0) {
            return EditorPanePopupHandler.hasImageSrc(editorPane, pos, position.x, position.y);
        }
        return null;
    }

    @Nullable
    public static String hasImageSrc(JEditorPane editorPane, int caretPosition, int offsetX, int offsetY) {
        HTML.Tag tag;
        HTMLDocument htmlDocument;
        Element e;
        AttributeSet a;
        Object tagName;
        Document document = editorPane.getDocument();
        if (document instanceof HTMLDocument && (tagName = (a = (e = (htmlDocument = (HTMLDocument)document).getCharacterElement(caretPosition)).getAttributes()).getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag && (tag = (HTML.Tag)tagName) == HTML.Tag.IMG) {
            return (String)a.getAttribute(HTML.Attribute.SRC);
        }
        return null;
    }

    private static void copyImageToClipboard(HTMLDocument document, String imageSrc) {
        try {
            Image image;
            URL reference = document.getBase();
            URL imageUrl = new URL(reference, imageSrc);
            Dictionary cache = (Dictionary)document.getProperty(IMAGE_CACHE_PROPERTY);
            if (cache != null) {
                image = (Image)cache.get(imageUrl);
            } else {
                image = Toolkit.getDefaultToolkit().createImage(imageUrl);
                if (image != null) {
                    ImageIcon ii = new ImageIcon();
                    ii.setImage(image);
                }
            }
            if (image != null) {
                ClipboardUtils.pasteImage((Image)image);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

