/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_command;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.parser_command.XBReader;
import org.exbin.xbup.parser_command.XBTCommandReader;
import org.exbin.xbup.parser_tree.XBBlockToXBTBlock;

@ParametersAreNonnullByDefault
public class XBTReader
implements XBTCommandReader,
Closeable {
    @Nonnull
    private final XBReader reader;

    public XBTReader() throws IOException {
        this.reader = new XBReader();
    }

    public XBTReader(InputStream stream) throws IOException {
        this.reader = new XBReader(stream);
    }

    public XBTReader(InputStream stream, XBParserMode parserMode) throws IOException {
        this.reader = new XBReader(stream, parserMode);
    }

    @Override
    public void open(@Nonnull InputStream stream) throws IOException {
        this.reader.open(stream);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void resetParser() throws IOException {
        this.reader.resetXB();
    }

    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        Optional<XBBlock> rootBlock = this.reader.getRootBlock();
        return rootBlock.isPresent() ? Optional.of(new XBBlockToXBTBlock(rootBlock.get())) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<XBTBlock> getBlock(long[] blockPath) {
        Optional<XBBlock> block = this.reader.getBlock(blockPath);
        return block.isPresent() ? Optional.of(new XBBlockToXBTBlock(block.get())) : Optional.empty();
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.reader.getTailData();
    }

    public long getTailDataSize() {
        return this.reader.getTailDataSize();
    }

    public long getDocumentSize() {
        return this.reader.getDocumentSize();
    }
}

