/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.delta.DataSegment;
import org.exbin.auxiliary.binary_data.delta.FileDataSource;

@ParametersAreNonnullByDefault
public class FileSegment
extends DataSegment {
    @Nonnull
    private final FileDataSource source;
    private long startPosition;
    private long length;

    public FileSegment(FileDataSource source, long startPosition, long length) {
        this.source = source;
        this.startPosition = startPosition;
        this.length = length;
    }

    @Nonnull
    public FileDataSource getSource() {
        return this.source;
    }

    @Override
    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public byte getByte(long position) {
        return this.source.getByte(position);
    }

    @Override
    @Nonnull
    public DataSegment copy() {
        return new FileSegment(this.source, this.startPosition, this.length);
    }
}

