/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.tool.xbeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exbin.framework.XBBaseApplication;
import org.exbin.framework.about.api.AboutModuleApi;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.inspector.BinedInspectorModule;
import org.exbin.framework.client.api.ClientModuleApi;
import org.exbin.framework.docking.api.DockingModuleApi;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.EditorProviderVariant;
import org.exbin.framework.editor.text.EditorTextModule;
import org.exbin.framework.editor.xbup.EditorXbupModule;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.help.api.HelpModuleApi;
import org.exbin.framework.help.online.api.HelpOnlineModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.update.api.UpdateModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.operation.undo.XBTLinearUndo;

@ParametersAreNonnullByDefault
public class XBEditor {
    private static final String XBUP_PLUGIN_ID = "xbup";
    private static final String OPTION_HELP = "h";
    private static final String OPTION_VERBOSE = "v";
    private static final String OPTION_DEV = "dev";
    private static final String OPTION_NODEV = "nodev";
    private static final String OPTION_SINGLE_FILE = "single_file";
    private static final String OPTION_MULTI_FILE = "multi_file";
    private static final String OPTION_FULLSCREEN = "fullscreen";
    private static final ResourceBundle bundle = LanguageUtils.getResourceBundleByClass(XBEditor.class);

    private XBEditor() {
    }

    public static void main(String[] args) {
        block8: {
            Logger logger = Logger.getLogger("");
            try {
                Options opt = new Options();
                opt.addOption(OPTION_HELP, "help", false, bundle.getString("cl_option_help"));
                opt.addOption(OPTION_VERBOSE, false, bundle.getString("cl_option_verbose"));
                opt.addOption(OPTION_DEV, false, bundle.getString("cl_option_dev"));
                opt.addOption(OPTION_NODEV, false, bundle.getString("cl_option_nodev"));
                opt.addOption(OPTION_FULLSCREEN, false, bundle.getString("cl_option_fullscreen"));
                OptionGroup editorProviderType = new OptionGroup();
                editorProviderType.addOption(new Option(OPTION_SINGLE_FILE, bundle.getString("cl_option_single_file")));
                editorProviderType.addOption(new Option(OPTION_MULTI_FILE, bundle.getString("cl_option_multi_file")));
                opt.addOptionGroup(editorProviderType);
                BasicParser parser = new BasicParser();
                CommandLine cl = parser.parse(opt, args);
                if (cl.hasOption(OPTION_HELP)) {
                    HelpFormatter f = new HelpFormatter();
                    f.printHelp(bundle.getString("cl_syntax"), opt);
                    break block8;
                }
                boolean verboseMode = cl.hasOption(OPTION_VERBOSE);
                boolean devModeOpt = false;
                boolean fullScreenMode = cl.hasOption(OPTION_FULLSCREEN);
                if (cl.hasOption(OPTION_NODEV)) {
                    if (cl.hasOption(OPTION_DEV)) {
                        logger.severe(bundle.getString("cl_error") + bundle.getString("cl_error_dev_conflict"));
                        return;
                    }
                } else {
                    devModeOpt = cl.hasOption(OPTION_DEV) || "DEV".equals(bundle.getString("Application.mode"));
                }
                boolean devMode = devModeOpt;
                String editorProvideType = editorProviderType.getSelected();
                try {
                    logger.setLevel(Level.ALL);
                    logger.addHandler((Handler)new XBHead.XBLogHandler(verboseMode));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                XBBaseApplication app = new XBBaseApplication();
                app.setAppDirectory(XBEditor.class);
                Preferences preferences = app.createPreferences(XBEditor.class);
                app.setAppBundle(bundle, LanguageUtils.getResourceBaseNameBundleByClass(XBEditor.class));
                XBApplicationModuleRepository moduleRepository = app.getModuleRepository();
                Thread.currentThread().setContextClassLoader(moduleRepository.getContextClassLoader());
                app.init();
                app.run(() -> {
                    moduleRepository.addClassPathModules();
                    moduleRepository.addModulesFromManifest(XBEditor.class);
                    moduleRepository.loadModulesFromPath(new File(app.getAppDirectory().getAbsoluteFile(), "plugins").toURI());
                    moduleRepository.initModules();
                    app.init();
                    FrameModuleApi frameModule = (FrameModuleApi)moduleRepository.getModuleByInterface(FrameModuleApi.class);
                    EditorModuleApi editorModule = (EditorModuleApi)moduleRepository.getModuleByInterface(EditorModuleApi.class);
                    ActionModuleApi actionModule = (ActionModuleApi)moduleRepository.getModuleByInterface(ActionModuleApi.class);
                    AboutModuleApi aboutModule = (AboutModuleApi)moduleRepository.getModuleByInterface(AboutModuleApi.class);
                    HelpModuleApi helpModule = (HelpModuleApi)moduleRepository.getModuleByInterface(HelpModuleApi.class);
                    HelpOnlineModuleApi helpOnlineModule = (HelpOnlineModuleApi)moduleRepository.getModuleByInterface(HelpOnlineModuleApi.class);
                    OperationUndoModuleApi undoModule = (OperationUndoModuleApi)moduleRepository.getModuleByInterface(OperationUndoModuleApi.class);
                    FileModuleApi fileModule = (FileModuleApi)moduleRepository.getModuleByInterface(FileModuleApi.class);
                    DockingModuleApi dockingModule = (DockingModuleApi)moduleRepository.getModuleByInterface(DockingModuleApi.class);
                    UpdateModuleApi updateModule = (UpdateModuleApi)moduleRepository.getModuleByInterface(UpdateModuleApi.class);
                    ClientModuleApi clientModule = (ClientModuleApi)moduleRepository.getModuleByInterface(ClientModuleApi.class);
                    OptionsModuleApi optionsModule = (OptionsModuleApi)moduleRepository.getModuleByInterface(OptionsModuleApi.class);
                    boolean multiFileMode = true;
                    EditorProviderVariant editorProviderVariant = editorProvideType != null ? (OPTION_SINGLE_FILE.equals(editorProvideType) ? EditorProviderVariant.SINGLE : EditorProviderVariant.MULTI) : (multiFileMode ? EditorProviderVariant.MULTI : EditorProviderVariant.SINGLE);
                    EditorXbupModule xbupEditorModule = (EditorXbupModule)moduleRepository.getModuleByInterface(EditorXbupModule.class);
                    EditorTextModule textEditorModule = (EditorTextModule)moduleRepository.getModuleByInterface(EditorTextModule.class);
                    BinedModule binaryModule = (BinedModule)moduleRepository.getModuleByInterface(BinedModule.class);
                    xbupEditorModule.initEditorProvider(editorProviderVariant);
                    EditorProvider editorProvider = xbupEditorModule.getEditorProvider();
                    editorModule.registerEditor(XBUP_PLUGIN_ID, editorProvider);
                    binaryModule.initEditorProvider(EditorProviderVariant.MULTI);
                    binaryModule.setEditorProvider(editorProvider);
                    binaryModule.registerCodeAreaPopupMenu();
                    BinedInspectorModule binedInspectorModule = (BinedInspectorModule)moduleRepository.getModuleByInterface(BinedInspectorModule.class);
                    binedInspectorModule.setEditorProvider(editorProvider);
                    frameModule.createMainMenu();
                    xbupEditorModule.setDevMode(devMode);
                    try {
                        updateModule.setUpdateUrl(new URL(bundle.getString("update_url")));
                        updateModule.setUpdateDownloadUrl(new URL(bundle.getString("update_download_url")));
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(XBEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    updateModule.registerDefaultMenuItem();
                    aboutModule.registerDefaultMenuItem();
                    helpModule.registerMainMenu();
                    try {
                        helpOnlineModule.setOnlineHelpUrl(new URL(bundle.getString("online_help_url")));
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(XBEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    helpOnlineModule.registerOnlineHelpMenu();
                    frameModule.registerExitAction();
                    frameModule.registerBarsVisibilityActions();
                    fileModule.registerMenuFileHandlingActions();
                    if (editorProviderVariant == EditorProviderVariant.MULTI) {
                        editorModule.registerMenuFileCloseActions();
                    }
                    fileModule.registerToolBarFileHandlingActions();
                    fileModule.registerCloseListener();
                    fileModule.registerRecenFilesMenuActions();
                    undoModule.registerMainMenu();
                    undoModule.registerMainToolBar();
                    undoModule.registerUndoManagerInMainMenu();
                    XBTLinearUndo linearUndo = new XBTLinearUndo(null);
                    actionModule.registerClipboardTextActions();
                    actionModule.registerMenuClipboardActions();
                    actionModule.registerToolBarClipboardActions();
                    optionsModule.registerMenuAction();
                    textEditorModule.registerEditFindMenuActions();
                    textEditorModule.registerWordWrapping();
                    textEditorModule.registerGoToLine();
                    xbupEditorModule.setDevMode(devMode);
                    xbupEditorModule.registerFileTypes();
                    xbupEditorModule.registerCatalogBrowserMenu();
                    xbupEditorModule.registerDocEditingMenuActions();
                    xbupEditorModule.registerDocEditingToolBarActions();
                    xbupEditorModule.registerSampleFilesSubMenuActions();
                    xbupEditorModule.registerPropertiesMenuAction();
                    textEditorModule.registerToolsOptionsMenuActions();
                    textEditorModule.registerOptionsPanels();
                    xbupEditorModule.registerOptionsPanels();
                    updateModule.registerOptionsPanels();
                    binaryModule.registerCodeAreaPopupEventDispatcher();
                    ApplicationFrameHandler frameHandler = frameModule.getFrameHandler();
                    editorModule.registerUndoHandler();
                    xbupEditorModule.registerStatusBar();
                    frameHandler.setMainPanel((Component)editorModule.getEditorComponent());
                    frameHandler.setDefaultSize(new Dimension(600, 400));
                    optionsModule.initialLoadFromPreferences();
                    frameHandler.showFrame();
                    if (editorProviderVariant == EditorProviderVariant.SINGLE) {
                        ((XbupFileHandler)editorProvider.getActiveFile().get()).postWindowOpened();
                    }
                    updateModule.checkOnStart(frameHandler.getFrame());
                    clientModule.addClientConnectionListener(xbupEditorModule.getClientConnectionListener());
                    clientModule.addPluginRepositoryListener(pluginRepository -> xbupEditorModule.setPluginRepository(pluginRepository));
                    clientModule.setDevMode(devMode);
                    Thread connectionThread = new Thread(() -> {
                        if (!clientModule.connectToService() && !clientModule.runLocalCatalog()) {
                            clientModule.useBuildInCatalog();
                        }
                        XBACatalog catalog = clientModule.getCatalog();
                        xbupEditorModule.setCatalog(catalog);
                    });
                    connectionThread.start();
                    List fileArgs = cl.getArgList();
                    if (!fileArgs.isEmpty()) {
                        fileModule.loadFromFile((String)fileArgs.get(0));
                    }
                });
            }
            catch (ParseException ex) {
                Logger.getLogger(XBEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

