/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.paged;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.FinishableStream;
import org.exbin.auxiliary.binary_data.SeekableStream;
import org.exbin.auxiliary.binary_data.paged.PagedData;

@ParametersAreNonnullByDefault
public class PagedDataInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final PagedData data;
    private long position = 0L;
    private long mark = 0L;

    public PagedDataInputStream(PagedData data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.data.getByte(this.position++);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    @Override
    public int read(byte[] output, int off, int len) throws IOException {
        if (output.length == 0 || len == 0) {
            return 0;
        }
        int length = len;
        int offset = off;
        while (length > 0) {
            int srcPos;
            int pageIndex = (int)(this.position / (long)this.data.getPageSize());
            if (pageIndex >= this.data.getPagesCount()) {
                return offset == off ? -1 : offset - off;
            }
            byte[] page = this.data.getPage(pageIndex);
            int copyLength = page.length - (srcPos = (int)(this.position % (long)this.data.getPageSize()));
            if (copyLength > length) {
                copyLength = length;
            }
            if (copyLength == 0) {
                return len == length ? -1 : len - length;
            }
            System.arraycopy(page, srcPos, output, offset, copyLength);
            length -= copyLength;
            this.position += (long)copyLength;
            offset += copyLength;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.data.getDataSize() - this.position);
    }

    public void seek(long position) throws IOException {
        this.position = position;
    }

    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    public long getProcessedSize() {
        return this.position;
    }

    public long getStreamSize() {
        return this.data.getDataSize();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position + n < dataSize) {
            this.position += n;
            return n;
        }
        long skipped = dataSize - this.position;
        this.position = dataSize;
        return skipped;
    }
}

