/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.preferences;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.editor.text.options.TextColorOptions;

@ParametersAreNonnullByDefault
public class TextColorPreferences
implements TextColorOptions {
    public static final String PREFERENCES_TEXT_COLOR_DEFAULT = "textColor.default";
    public static final String PREFERENCES_TEXT_COLOR_TEXT = "textColor.text";
    public static final String PREFERENCES_TEXT_COLOR_BACKGROUND = "textColor.background";
    public static final String PREFERENCES_TEXT_COLOR_SELECTION = "textColor.selection";
    public static final String PREFERENCES_TEXT_COLOR_SELECTION_BACKGROUND = "textColor.selectionBackground";
    public static final String PREFERENCES_TEXT_COLOR_FOUND = "textColor.found";
    private final Preferences preferences;

    public TextColorPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public boolean isUseDefaultColors() {
        return this.preferences.getBoolean(PREFERENCES_TEXT_COLOR_DEFAULT, true);
    }

    @Override
    public void setUseDefaultColors(boolean useDefaultColor) {
        this.preferences.putBoolean(PREFERENCES_TEXT_COLOR_DEFAULT, useDefaultColor);
    }

    @Override
    @Nullable
    public Integer getTextColor() {
        return this.getColorAsInt(PREFERENCES_TEXT_COLOR_TEXT);
    }

    @Override
    @Nullable
    public Integer getTextBackgroundColor() {
        return this.getColorAsInt(PREFERENCES_TEXT_COLOR_BACKGROUND);
    }

    @Override
    @Nullable
    public Integer getSelectionTextColor() {
        return this.getColorAsInt(PREFERENCES_TEXT_COLOR_SELECTION);
    }

    @Override
    @Nullable
    public Integer getSelectionBackgroundColor() {
        return this.getColorAsInt(PREFERENCES_TEXT_COLOR_SELECTION_BACKGROUND);
    }

    @Override
    @Nullable
    public Integer getFoundBackgroundColor() {
        return this.getColorAsInt(PREFERENCES_TEXT_COLOR_FOUND);
    }

    @Nullable
    private Integer getColorAsInt(String key) {
        Optional value = this.preferences.get(key);
        return value.isPresent() ? Integer.valueOf((String)value.get()) : null;
    }

    @Override
    public void setTextColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_TEXT_COLOR_TEXT, color);
    }

    public void setTextColor(int color) {
        this.preferences.putInt(PREFERENCES_TEXT_COLOR_TEXT, color);
    }

    @Override
    public void setTextBackgroundColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_TEXT_COLOR_BACKGROUND, color);
    }

    public void setTextBackgroundColor(int color) {
        this.preferences.putInt(PREFERENCES_TEXT_COLOR_BACKGROUND, color);
    }

    @Override
    public void setSelectionTextColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_TEXT_COLOR_SELECTION, color);
    }

    public void setSelectionTextColor(int color) {
        this.preferences.putInt(PREFERENCES_TEXT_COLOR_SELECTION, color);
    }

    @Override
    public void setSelectionBackgroundColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_TEXT_COLOR_SELECTION_BACKGROUND, color);
    }

    public void setSelectionBackgroundColor(int color) {
        this.preferences.putInt(PREFERENCES_TEXT_COLOR_SELECTION_BACKGROUND, color);
    }

    @Override
    public void setFoundBackgroundColor(@Nullable Integer color) {
        this.setColor(PREFERENCES_TEXT_COLOR_FOUND, color);
    }

    public void setFoundBackgroundColor(int color) {
        this.preferences.putInt(PREFERENCES_TEXT_COLOR_FOUND, color);
    }

    private void setColor(String preferenceName, @Nullable Integer color) {
        if (color == null) {
            this.preferences.remove(preferenceName);
        } else {
            this.preferences.putInt(preferenceName, color.intValue());
        }
    }
}

