/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.editor.text.options.TextEncodingOptions;

@ParametersAreNonnullByDefault
public class TextEncodingPreferences
implements TextEncodingOptions {
    public static final String PREFERENCES_TEXT_ENCODING_PREFIX = "textEncoding.";
    public static final String PREFERENCES_TEXT_ENCODING_DEFAULT = "textEncoding.default";
    public static final String PREFERENCES_TEXT_ENCODING_SELECTED = "selectedEncoding";
    private final Preferences preferences;

    public TextEncodingPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public String getDefaultEncoding() {
        return this.preferences.get(PREFERENCES_TEXT_ENCODING_DEFAULT, "UTF-8");
    }

    public void setDefaultEncoding(String encodingName) {
        this.preferences.put(PREFERENCES_TEXT_ENCODING_DEFAULT, encodingName);
    }

    @Override
    @Nonnull
    public String getSelectedEncoding() {
        return this.preferences.get(PREFERENCES_TEXT_ENCODING_SELECTED, "UTF-8");
    }

    @Override
    public void setSelectedEncoding(String encodingName) {
        this.preferences.put(PREFERENCES_TEXT_ENCODING_SELECTED, encodingName);
    }

    @Override
    @Nonnull
    public List<String> getEncodings() {
        Optional value;
        ArrayList<String> encodings = new ArrayList<String>();
        int i = 0;
        do {
            if (!(value = this.preferences.get(PREFERENCES_TEXT_ENCODING_PREFIX + Integer.toString(i))).isPresent()) continue;
            encodings.add((String)value.get());
            ++i;
        } while (value.isPresent());
        return encodings;
    }

    @Override
    public void setEncodings(List<String> encodings) {
        for (int i = 0; i < encodings.size(); ++i) {
            this.preferences.put(PREFERENCES_TEXT_ENCODING_PREFIX + Integer.toString(i), encodings.get(i));
        }
        this.preferences.remove(PREFERENCES_TEXT_ENCODING_PREFIX + Integer.toString(encodings.size()));
    }
}

