/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.editor.text.options.impl.TextEncodingOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextEncodingPanel
extends JPanel
implements OptionsComponent<TextEncodingOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextEncodingPanel.class);
    private AddEncodingsOperation addEncodingsOperation = null;
    private JButton addButton;
    private JButton downButton;
    private JPanel encodingsControlPanel;
    private JList encodingsList;
    private JScrollPane encodingsListScrollPane;
    private JButton removeButton;
    private JButton selectAllButton;
    private JButton upButton;

    public TextEncodingPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.encodingsList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                TextEncodingPanel.this.selectAllButton.setEnabled(TextEncodingPanel.this.encodingsList.getModel().getSize() > 0);
            }
        });
        this.encodingsList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean emptySelection = this.encodingsList.isSelectionEmpty();
                this.removeButton.setEnabled(!emptySelection);
                this.selectAllButton.setEnabled(this.encodingsList.getModel().getSize() > 0);
                if (!emptySelection) {
                    int[] indices = this.encodingsList.getSelectedIndices();
                    this.upButton.setEnabled(this.encodingsList.getMaxSelectionIndex() >= indices.length);
                    this.downButton.setEnabled(this.encodingsList.getMinSelectionIndex() + indices.length < this.encodingsList.getModel().getSize());
                } else {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                }
            }
        });
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void saveToOptions(TextEncodingOptionsImpl options) {
        options.setEncodings(this.getEncodingList());
    }

    public void loadFromOptions(TextEncodingOptionsImpl options) {
        this.setEncodingList(options.getEncodings());
    }

    private void initComponents() {
        this.encodingsListScrollPane = new JScrollPane();
        this.encodingsList = new JList();
        this.encodingsControlPanel = new JPanel();
        this.addButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.selectAllButton = new JButton();
        this.removeButton = new JButton();
        this.setName("Form");
        this.encodingsListScrollPane.setName("encodingsListScrollPane");
        this.encodingsList.setModel(new EncodingsListModel());
        this.encodingsList.setName("encodingsList");
        this.encodingsListScrollPane.setViewportView(this.encodingsList);
        this.encodingsControlPanel.setName("encodingsControlPanel");
        this.addButton.setText(this.resourceBundle.getString("addButton.text"));
        this.addButton.setName("addButton");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.upButton.setText(this.resourceBundle.getString("upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.setName("upButton");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText(this.resourceBundle.getString("downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.setName("downButton");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.selectAllButton.setText(this.resourceBundle.getString("selectAllButton.text"));
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.setName("selectAllButton");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(this.resourceBundle.getString("removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingPanel.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout encodingsControlPanelLayout = new GroupLayout(this.encodingsControlPanel);
        this.encodingsControlPanel.setLayout(encodingsControlPanelLayout);
        encodingsControlPanelLayout.setHorizontalGroup(encodingsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingsControlPanelLayout.createSequentialGroup().addContainerGap().addGroup(encodingsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, 118, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, 118, Short.MAX_VALUE).addComponent(this.selectAllButton, GroupLayout.Alignment.TRAILING, -1, 118, Short.MAX_VALUE).addComponent(this.downButton, GroupLayout.Alignment.TRAILING, -1, 118, Short.MAX_VALUE).addComponent(this.upButton, -1, 118, Short.MAX_VALUE)).addContainerGap()));
        encodingsControlPanelLayout.setVerticalGroup(encodingsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, encodingsControlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.encodingsListScrollPane, -1, 20, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingsControlPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodingsControlPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.encodingsListScrollPane).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        List<String> encodings;
        if (this.addEncodingsOperation != null && (encodings = this.addEncodingsOperation.run(((EncodingsListModel)this.encodingsList.getModel()).getCharsets())) != null) {
            ((EncodingsListModel)this.encodingsList.getModel()).addAll(encodings, this.encodingsList.getSelectedIndex());
            this.encodingsList.clearSelection();
            this.wasModified();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        ((EncodingsListModel)this.encodingsList.getModel()).removeIndices(this.encodingsList.getSelectedIndices());
        this.encodingsList.clearSelection();
        this.wasModified();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int[] indices = this.encodingsList.getSelectedIndices();
        int last = 0;
        for (int i = 0; i < indices.length; ++i) {
            int next = indices[i];
            if (last != next) {
                EncodingsListModel model = (EncodingsListModel)this.encodingsList.getModel();
                String item = model.getElementAt(next);
                model.add(next - 1, item);
                this.encodingsList.getSelectionModel().addSelectionInterval(next - 1, next - 1);
                model.remove(next + 1);
                continue;
            }
            ++last;
        }
        this.wasModified();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int[] indices = this.encodingsList.getSelectedIndices();
        int last = this.encodingsList.getModel().getSize() - 1;
        for (int i = indices.length; i > 0; --i) {
            int next = indices[i - 1];
            if (last != next) {
                EncodingsListModel model = (EncodingsListModel)this.encodingsList.getModel();
                String item = model.getElementAt(next);
                model.add(next + 2, item);
                this.encodingsList.getSelectionModel().addSelectionInterval(next + 2, next + 2);
                model.remove(next);
                continue;
            }
            --last;
        }
        this.wasModified();
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        if (this.encodingsList.getSelectedIndices().length < this.encodingsList.getModel().getSize()) {
            this.encodingsList.setSelectionInterval(0, this.encodingsList.getModel().getSize() - 1);
        } else {
            this.encodingsList.clearSelection();
        }
    }

    public void setEncodingList(List<String> list) {
        ((EncodingsListModel)this.encodingsList.getModel()).setCharsets(list);
        this.encodingsList.repaint();
    }

    public List<String> getEncodingList() {
        return ((EncodingsListModel)this.encodingsList.getModel()).getCharsets();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextEncodingPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener optionsModifiedListener) {
        this.optionsModifiedListener = optionsModifiedListener;
    }

    public void wasModified() {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setAddEncodingsOperation(AddEncodingsOperation addEncodingsOperation) {
        this.addEncodingsOperation = addEncodingsOperation;
    }

    public void addEncodings(List<String> encodings) {
        ((EncodingsListModel)this.encodingsList.getModel()).addAll(encodings, this.encodingsList.isSelectionEmpty() ? -1 : this.encodingsList.getSelectedIndex());
    }

    @ParametersAreNonnullByDefault
    private class EncodingsListModel
    extends AbstractListModel<String> {
        private final List<String> charsets = new ArrayList<String>();

        private EncodingsListModel() {
        }

        @Override
        public int getSize() {
            return this.charsets.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.charsets.get(index);
        }

        @Nonnull
        public List<String> getCharsets() {
            return this.charsets;
        }

        public void setCharsets(@Nullable List<String> charsets) {
            this.charsets.clear();
            if (charsets != null) {
                this.charsets.addAll(charsets);
            }
            this.fireContentsChanged(this, 0, this.charsets.size());
        }

        public void addAll(List<String> list, int pos) {
            if (pos >= 0) {
                this.charsets.addAll(pos, list);
                this.fireIntervalAdded(this, pos, list.size() + pos);
            } else {
                this.charsets.addAll(list);
                this.fireIntervalAdded(this, this.charsets.size() - list.size(), this.charsets.size());
            }
        }

        public void removeIndices(int[] indices) {
            if (indices.length == 0) {
                return;
            }
            for (int i = indices.length - 1; i >= 0; --i) {
                this.charsets.remove(indices[i]);
                this.fireIntervalRemoved(this, indices[i], indices[i]);
            }
        }

        public void remove(int index) {
            this.charsets.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void add(int index, String item) {
            this.charsets.add(index, item);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public static interface AddEncodingsOperation {
        public List<String> run(List<String> var1);
    }
}

