/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.editor.text.options.impl.TextAppearanceOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class TextAppearanceOptionsPanel
extends JPanel
implements OptionsComponent<TextAppearanceOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextAppearanceOptionsPanel.class);
    private JCheckBox wordWrapCheckBox;

    public TextAppearanceOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void saveToOptions(TextAppearanceOptionsImpl options) {
        options.setWordWrapping(this.wordWrapCheckBox.isSelected());
    }

    public void loadFromOptions(TextAppearanceOptionsImpl options) {
        this.wordWrapCheckBox.setSelected(options.isWordWrapping());
    }

    private void initComponents() {
        this.wordWrapCheckBox = new JCheckBox();
        this.setName("Form");
        this.wordWrapCheckBox.setSelected(true);
        this.wordWrapCheckBox.setText(this.resourceBundle.getString("wordWrapCheckBox.text"));
        this.wordWrapCheckBox.setName("wordWrapCheckBox");
        this.wordWrapCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextAppearanceOptionsPanel.this.wordWrapCheckBoxjCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.wordWrapCheckBox, -1, 274, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.wordWrapCheckBox)));
    }

    private void wordWrapCheckBoxjCheckBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextAppearanceOptionsPanel());
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

