/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.editor.text.TextPositionStatusApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class TextStatusPanel
extends JPanel
implements TextPositionStatusApi,
TextEncodingStatusApi {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextStatusPanel.class);
    private JTextField documentCursorPositionTextField;
    private JTextField documentEncodingTextField;
    private JLabel encodingLabel;

    public TextStatusPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.documentCursorPositionTextField = new JTextField();
        this.encodingLabel = new JLabel();
        this.documentEncodingTextField = new JTextField();
        this.setName("Form");
        this.documentCursorPositionTextField.setEditable(false);
        this.documentCursorPositionTextField.setHorizontalAlignment(0);
        this.documentCursorPositionTextField.setText("1:1");
        this.documentCursorPositionTextField.setToolTipText(this.resourceBundle.getString("documentCursorPositionTextField.toolTipText"));
        this.documentCursorPositionTextField.setName("documentCursorPositionTextField");
        this.encodingLabel.setText(this.resourceBundle.getString("encodingLabel.text"));
        this.encodingLabel.setName("encodingLabel");
        this.documentEncodingTextField.setEditable(false);
        this.documentEncodingTextField.setHorizontalAlignment(0);
        this.documentEncodingTextField.setText("UTF-8");
        this.documentEncodingTextField.setToolTipText(this.resourceBundle.getString("documentEncodingTextField.toolTipText"));
        this.documentEncodingTextField.setName("documentEncodingTextField");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.documentCursorPositionTextField, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 397, Short.MAX_VALUE).addComponent(this.encodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentEncodingTextField, -2, 93, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.documentCursorPositionTextField, -1, 26, Short.MAX_VALUE).addComponent(this.documentEncodingTextField, -2, 22, -2).addComponent(this.encodingLabel)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextStatusPanel());
    }

    @Override
    public void setTextPosition(String textPosition) {
        this.documentCursorPositionTextField.setText(textPosition);
    }

    @Override
    public String getEncoding() {
        return this.documentEncodingTextField.getText();
    }

    @Override
    public void setEncoding(String encodingName) {
        this.documentEncodingTextField.setText(encodingName);
    }
}

