/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.print.PrinterException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.undo.UndoableEdit;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.TextCharsetApi;
import org.exbin.framework.editor.text.TextFontApi;
import org.exbin.framework.editor.text.gui.TextPanelCompoundUndoManager;
import org.exbin.framework.editor.text.gui.TextStatusPanel;
import org.exbin.framework.editor.text.service.TextSearchService;
import org.exbin.framework.editor.text.service.impl.TextServiceImpl;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.operation.undo.api.UndoUpdateListener;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextPanel
extends JPanel
implements ClipboardActionsHandler,
UndoActionsHandler,
TextCharsetApi,
TextFontApi {
    private final TextPanelCompoundUndoManager undoManagement = new TextPanelCompoundUndoManager();
    private UndoUpdateListener undoUpdateListener = null;
    private boolean modified = false;
    private Object highlight;
    private Color foundTextBackgroundColor;
    private Charset charset;
    private Font defaultFont;
    private Color[] defaultColors;
    private CharsetChangeListener charsetChangeListener = null;
    private TextStatusPanel textStatus = null;
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    private EditorProvider.EditorModificationListener editorModificationListener;
    private JTextArea textArea;
    private JScrollPane textAreaScrollPane;

    public TextPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.highlight = null;
        this.foundTextBackgroundColor = Color.YELLOW;
        this.charset = Charset.forName("UTF-8");
        this.defaultFont = this.textArea.getFont();
        this.defaultColors = new Color[5];
        this.defaultColors[0] = new Color(this.textArea.getForeground().getRGB());
        this.defaultColors[1] = new Color(SystemColor.text.getRGB());
        this.defaultColors[2] = new Color(this.textArea.getSelectedTextColor().getRGB());
        this.defaultColors[3] = new Color(this.textArea.getSelectionColor().getRGB());
        this.defaultColors[4] = this.foundTextBackgroundColor;
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextPanel.this.setModified(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextPanel.this.setModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextPanel.this.setModified(true);
            }
        });
        this.textArea.getDocument().addUndoableEditListener(evt -> {
            this.undoManagement.undoableEditHappened(evt);
            if (this.undoUpdateListener != null) {
                this.undoUpdateListener.undoChanged();
            }
        });
        this.textArea.addCaretListener(e -> {
            if (this.clipboardActionsUpdateListener != null) {
                this.clipboardActionsUpdateListener.stateChanged();
            }
        });
    }

    public boolean changeLineWrap() {
        this.textArea.setLineWrap(!this.textArea.getLineWrap());
        return this.textArea.getLineWrap();
    }

    public boolean getWordWrapMode() {
        return this.textArea.getLineWrap();
    }

    public void setWordWrapMode(boolean mode) {
        if (this.textArea.getLineWrap() != mode) {
            this.changeLineWrap();
        }
    }

    public void findText(TextSearchService.FindTextParameters findTextParameters) {
        int pos = this.textArea.getCaretPosition();
        if (this.highlight != null) {
            if (((Highlighter.Highlight)this.highlight).getStartOffset() == pos) {
                ++pos;
            }
            this.textArea.getHighlighter().removeHighlight(this.highlight);
        } else if (findTextParameters.isSearchFromStart()) {
            pos = 0;
        }
        findTextParameters.setStartFrom(pos);
        TextServiceImpl textService = new TextServiceImpl();
        TextSearchService.FoundMatch foundMatch = textService.findText(this.textArea, findTextParameters);
        if (foundMatch != null) {
            try {
                this.textArea.setCaretPosition(foundMatch.getTo());
                this.highlight = this.textArea.getHighlighter().addHighlight(foundMatch.getFrom(), foundMatch.getTo(), new DefaultHighlighter.DefaultHighlightPainter(this.foundTextBackgroundColor));
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(UiUtils.getFrame((Component)this), "String was not found", "Find text", 1);
            this.highlight = null;
        }
    }

    @Nonnull
    public Color[] getCurrentColors() {
        Color[] colors = new Color[]{this.textArea.getForeground(), this.textArea.getBackground(), this.textArea.getSelectedTextColor(), this.textArea.getSelectionColor(), this.getFoundTextBackgroundColor()};
        return colors;
    }

    public Color[] getDefaultColors() {
        return this.defaultColors;
    }

    public void setCurrentColors(Color[] colors) {
        if (colors[0] != null) {
            this.textArea.setForeground(colors[0]);
        }
        if (colors[1] != null) {
            this.textArea.setBackground(colors[1]);
        }
        if (colors[2] != null) {
            this.textArea.setSelectedTextColor(colors[2]);
        }
        if (colors[3] != null) {
            this.textArea.setSelectionColor(colors[3]);
        }
        if (colors[4] != null) {
            this.setFoundTextBackgroundColor(colors[4]);
        }
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public int getLineCount() {
        return this.textArea.getLineCount();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setNoBorder() {
        this.textAreaScrollPane.setBorder(null);
    }

    public void gotoLine(int line) {
        try {
            this.textArea.setCaretPosition(this.textArea.getLineStartOffset(line - 1));
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TextPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void gotoRelative(int charPos) {
        this.textArea.setCaretPosition(this.textArea.getCaretPosition() + charPos - 1);
    }

    public void performCopy() {
        this.textArea.copy();
    }

    public void performCut() {
        this.textArea.cut();
    }

    public void performDelete() {
        this.textArea.getInputContext().dispatchEvent(new KeyEvent(this, 401, 0L, 0, 127, '\uffff'));
    }

    public void performPaste() {
        this.textArea.paste();
    }

    public void performSelectAll() {
        this.textArea.selectAll();
    }

    public void performUndoManager() {
    }

    public boolean isSelection() {
        return this.textArea.getSelectionEnd() > this.textArea.getSelectionStart();
    }

    public void printFile() {
        try {
            this.textArea.print();
        }
        catch (PrinterException ex) {
            Logger.getLogger(TextPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setCurrentFont(Font font) {
        this.textArea.setFont(font);
    }

    @Override
    public Font getCurrentFont() {
        return this.textArea.getFont();
    }

    public Color getFoundTextBackgroundColor() {
        return this.foundTextBackgroundColor;
    }

    public void setFoundTextBackgroundColor(Color color) {
        this.foundTextBackgroundColor = color;
    }

    public EditorProvider.EditorModificationListener getEditorModificationListener() {
        return this.editorModificationListener;
    }

    public void setEditorModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
        this.editorModificationListener = editorModificationListener;
    }

    private void initComponents() {
        this.textAreaScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.setInheritsPopupMenu(true);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.textAreaScrollPane.setName("textAreaScrollPane");
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.textArea.setName("textArea");
        this.textAreaScrollPane.setViewportView(this.textArea);
        this.add((Component)this.textAreaScrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextPanel());
    }

    public void setModified(boolean modified) {
        if (this.highlight != null) {
            this.textArea.getHighlighter().removeHighlight(this.highlight);
            this.highlight = null;
        }
        boolean oldValue = this.modified;
        this.modified = modified;
        if (this.editorModificationListener != null) {
            this.editorModificationListener.modified();
        }
        this.firePropertyChange("modified", oldValue, this.modified);
    }

    public UndoableEdit getUndo() {
        return this.undoManagement;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.textArea.setComponentPopupMenu(menu);
    }

    public void setUndoUpdateListener(UndoUpdateListener undoUpdateListener) {
        this.undoUpdateListener = undoUpdateListener;
    }

    @Nonnull
    public Point getCaretPosition() {
        int caretPosition = this.textArea.getCaretPosition();
        Element root = this.textArea.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(caretPosition);
        try {
            return new Point(caretPosition - this.textArea.getLineStartOffset(line) + 1, line + 1);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TextPanel.class.getName()).log(Level.SEVERE, null, ex);
            return new Point(0, 0);
        }
    }

    public void attachCaretListener(ChangeListener listener) {
        this.textArea.getCaret().addChangeListener(listener);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public boolean canUndo() {
        return this.getUndo().canUndo();
    }

    public boolean canRedo() {
        return this.getUndo().canRedo();
    }

    public void performUndo() {
        this.getUndo().undo();
    }

    public void performRedo() {
        this.getUndo().redo();
    }

    public void setCharsetChangeListener(CharsetChangeListener charsetChangeListener) {
        this.charsetChangeListener = charsetChangeListener;
    }

    public void changeCharset(Charset charset) {
        this.charset = charset;
        if (this.charsetChangeListener != null) {
            this.charsetChangeListener.charsetChanged();
        }
    }

    public void registerTextStatus(TextStatusPanel textStatusPanel) {
        this.textStatus = textStatusPanel;
        this.attachCaretListener(e -> {
            Point pos = this.getCaretPosition();
            String textPosition = Long.toString((long)pos.getX()) + ":" + Long.toString((long)pos.getY());
            this.textStatus.setTextPosition(textPosition);
        });
        this.setCharsetChangeListener(() -> this.textStatus.setEncoding(this.getCharset().name()));
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
        this.clipboardActionsUpdateListener = updateListener;
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public boolean canSelectAll() {
        return this.textArea.getSelectionEnd() > this.textArea.getSelectionStart();
    }

    public boolean canPaste() {
        Clipboard clipboard = ClipboardUtils.getClipboard();
        return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
    }

    public boolean canDelete() {
        return this.textArea.isEditable();
    }

    public void addTextAreaFocusListener(FocusListener focusListener) {
        this.textArea.addFocusListener(focusListener);
    }

    public void removeTextAreaFocusListener(FocusListener focusListener) {
        this.textArea.removeFocusListener(focusListener);
    }

    public boolean isModified() {
        return this.modified;
    }

    public static interface CharsetChangeListener {
        public void charsetChanged();
    }
}

