/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class WordWrappingAction
extends AbstractAction {
    public static final String ACTION_ID = "viewWordWrappingAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("type", ActionUtils.ActionType.CHECK);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        TextPanel textPanel = (TextPanel)((FileHandler)activeFile.get()).getComponent();
        boolean lineWraping = textPanel.changeLineWrap();
        this.putValue("SwingSelectedKey", lineWraping);
    }
}

