/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.editor.text.options.gui.TextColorPanel;
import org.exbin.framework.editor.text.options.impl.TextColorOptionsImpl;
import org.exbin.framework.editor.text.preferences.TextColorPreferences;
import org.exbin.framework.editor.text.service.TextColorService;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.OptionsControlPanel;
import org.exbin.framework.utils.handler.OptionsControlHandler;

@ParametersAreNonnullByDefault
public class TextColorAction
extends AbstractAction {
    public static final String ACTION_ID = "toolsSetColorAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        TextColorService textColorService = new TextColorService(){

            @Override
            public Color[] getCurrentTextColors() {
                Optional activeFile = TextColorAction.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                TextPanel textPanel = (TextPanel)((FileHandler)activeFile.get()).getComponent();
                return textPanel.getCurrentColors();
            }

            @Override
            public Color[] getDefaultTextColors() {
                Optional activeFile = TextColorAction.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                TextPanel textPanel = (TextPanel)((FileHandler)activeFile.get()).getComponent();
                return textPanel.getDefaultColors();
            }

            @Override
            public void setCurrentTextColors(Color[] colors) {
                Optional activeFile = TextColorAction.this.editorProvider.getActiveFile();
                if (!activeFile.isPresent()) {
                    throw new IllegalStateException();
                }
                TextPanel textPanel = (TextPanel)((FileHandler)activeFile.get()).getComponent();
                textPanel.setCurrentColors(colors);
            }
        };
        TextColorPanel colorPanel = new TextColorPanel();
        colorPanel.setTextColorService(textColorService);
        colorPanel.setColorsFromArray(textColorService.getCurrentTextColors());
        OptionsControlPanel controlPanel = new OptionsControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)colorPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), colorPanel.getClass(), (ResourceBundle)colorPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, colorPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType != OptionsControlHandler.ControlActionType.CANCEL) {
                if (actionType == OptionsControlHandler.ControlActionType.SAVE) {
                    TextColorOptionsImpl options = new TextColorOptionsImpl();
                    colorPanel.saveToOptions(options);
                    TextColorPreferences textColorParameters = new TextColorPreferences(this.application.getAppPreferences());
                    options.saveToPreferences(textColorParameters);
                }
                textColorService.setCurrentTextColors(colorPanel.getArrayFromColors());
            }
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)frameModule.getFrame());
    }
}

