/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic.color;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.UIManager;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class BasicCodeAreaColorsProfile
implements CodeAreaColorsProfile {
    @Nullable
    private Color textColor;
    @Nullable
    private Color textBackground;
    @Nullable
    private Color selectionColor;
    @Nullable
    private Color selectionBackground;
    @Nullable
    private Color selectionMirrorColor;
    @Nullable
    private Color selectionMirrorBackground;
    @Nullable
    private Color alternateColor;
    @Nullable
    private Color alternateBackground;
    @Nullable
    private Color cursorColor;
    @Nullable
    private Color cursorNegativeColor;
    @Nullable
    private Color decorationLine;

    @Nonnull
    public Color getTextColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.textColor);
    }

    @Nonnull
    public Color getTextBackground() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.textBackground);
    }

    @Nonnull
    public Color getSelectionColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.selectionColor);
    }

    @Nonnull
    public Color getSelectionBackground() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.selectionBackground);
    }

    @Nonnull
    public Color getSelectionMirrorColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.selectionMirrorColor);
    }

    @Nonnull
    public Color getSelectionMirrorBackground() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.selectionMirrorBackground);
    }

    @Nonnull
    public Color getAlternateColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.alternateColor);
    }

    @Nonnull
    public Color getAlternateBackground() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.alternateBackground);
    }

    @Nonnull
    public Color getCursorColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.cursorColor);
    }

    @Nonnull
    public Color getCursorNegativeColor() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.cursorNegativeColor);
    }

    @Nonnull
    public Color getDecorationLine() {
        return (Color)CodeAreaUtils.requireNonNull((Object)this.decorationLine);
    }

    @Override
    @Nullable
    public Color getColor(CodeAreaColorType colorType) {
        if (colorType == CodeAreaBasicColors.TEXT_COLOR) {
            return this.textColor;
        }
        if (colorType == CodeAreaBasicColors.TEXT_BACKGROUND) {
            return this.textBackground;
        }
        if (colorType == CodeAreaBasicColors.SELECTION_COLOR) {
            return this.selectionColor;
        }
        if (colorType == CodeAreaBasicColors.SELECTION_BACKGROUND) {
            return this.selectionBackground;
        }
        if (colorType == CodeAreaBasicColors.SELECTION_MIRROR_COLOR) {
            return this.selectionMirrorColor;
        }
        if (colorType == CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND) {
            return this.selectionMirrorBackground;
        }
        if (colorType == CodeAreaBasicColors.ALTERNATE_COLOR) {
            return this.alternateColor;
        }
        if (colorType == CodeAreaBasicColors.ALTERNATE_BACKGROUND) {
            return this.alternateBackground;
        }
        if (colorType == CodeAreaBasicColors.CURSOR_COLOR) {
            return this.cursorColor;
        }
        if (colorType == CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR) {
            return this.cursorNegativeColor;
        }
        if (colorType == BasicCodeAreaDecorationColorType.LINE) {
            return this.decorationLine;
        }
        return null;
    }

    @Override
    @Nullable
    public Color getColor(CodeAreaColorType colorType, @Nullable CodeAreaBasicColors basicAltColor) {
        Color color = this.getColor(colorType);
        return color == null ? (basicAltColor == null ? null : this.getColor((CodeAreaColorType)basicAltColor)) : color;
    }

    @Override
    public void reinitialize() {
        this.textColor = UIManager.getColor("TextArea.foreground");
        if (this.textColor == null) {
            this.textColor = Color.BLACK;
        }
        this.textBackground = UIManager.getColor("TextArea.background");
        if (this.textBackground == null) {
            this.textBackground = Color.WHITE;
        }
        this.selectionColor = UIManager.getColor("TextArea.selectionForeground");
        if (this.selectionColor == null) {
            this.selectionColor = Color.WHITE;
        }
        this.selectionBackground = UIManager.getColor("TextArea.selectionBackground");
        if (this.selectionBackground == null) {
            this.selectionBackground = new Color(96, 96, 255);
        }
        this.selectionMirrorColor = this.selectionColor;
        this.selectionMirrorBackground = CodeAreaSwingUtils.computeGrayColor(this.selectionBackground);
        this.cursorColor = UIManager.getColor("TextArea.caretForeground");
        if (this.cursorColor == null) {
            this.cursorColor = Color.BLACK;
        }
        this.cursorNegativeColor = CodeAreaSwingUtils.createNegativeColor(this.cursorColor);
        this.decorationLine = Color.GRAY;
        this.alternateColor = this.textColor;
        this.alternateBackground = CodeAreaSwingUtils.createOddColor(this.textBackground);
    }
}

