/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.delta.DataSegment;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.auxiliary.binary_data.delta.FileDataSource;
import org.exbin.auxiliary.binary_data.delta.FileSegment;
import org.exbin.auxiliary.binary_data.delta.MemoryDataSource;
import org.exbin.auxiliary.binary_data.delta.MemorySegment;
import org.exbin.auxiliary.binary_data.delta.SpaceSegment;
import org.exbin.auxiliary.binary_data.delta.list.DefaultDoublyLinkedList;
import org.exbin.auxiliary.binary_data.delta.list.DoublyLinkedItem;
import org.exbin.auxiliary.binary_data.paged.DataPageProvider;
import org.exbin.auxiliary.binary_data.paged.PagedData;

@ParametersAreNonnullByDefault
public class SegmentsRepository {
    @Nonnull
    private final Map<FileDataSource, DataSegmentsMap> fileSources = new HashMap<FileDataSource, DataSegmentsMap>();
    @Nonnull
    private final Map<MemoryDataSource, DataSegmentsMap> memorySources = new HashMap<MemoryDataSource, DataSegmentsMap>();
    @Nonnull
    private final List<DeltaDocument> documents = new ArrayList<DeltaDocument>();
    private static final int PROCESSING_LIMIT = 4096;
    @Nullable
    private final DataPageProvider dataPageProvider;

    public SegmentsRepository() {
        this(null);
    }

    public SegmentsRepository(DataPageProvider dataPageProvider) {
        this.dataPageProvider = dataPageProvider;
    }

    @Nonnull
    public FileDataSource openFileSource(File sourceFile) throws IOException {
        FileDataSource fileSource = new FileDataSource(sourceFile);
        this.fileSources.put(fileSource, new DataSegmentsMap());
        return fileSource;
    }

    @Nonnull
    public FileDataSource openFileSource(File sourceFile, FileDataSource.EditMode editMode) throws IOException {
        FileDataSource fileSource = new FileDataSource(sourceFile, editMode);
        this.fileSources.put(fileSource, new DataSegmentsMap());
        return fileSource;
    }

    public void closeFileSource(FileDataSource fileSource) {
        fileSource.close();
    }

    @Nonnull
    public MemoryDataSource openMemorySource() {
        PagedData pagedData = new PagedData();
        if (this.dataPageProvider != null) {
            pagedData.setDataPageProvider(this.dataPageProvider);
        }
        MemoryDataSource memorySource = new MemoryDataSource((EditableBinaryData)pagedData);
        this.memorySources.put(memorySource, new DataSegmentsMap());
        return memorySource;
    }

    public void closeMemorySource(MemoryDataSource memorySource) {
        memorySource.clear();
    }

    @Nonnull
    public DeltaDocument createDocument() {
        DeltaDocument document = new DeltaDocument(this);
        this.documents.add(document);
        return document;
    }

    @Nonnull
    public DeltaDocument createDocument(FileDataSource fileSource) throws IOException {
        DeltaDocument document = new DeltaDocument(this, fileSource);
        this.documents.add(document);
        return document;
    }

    public void saveDocument(DeltaDocument savedDocument) throws IOException {
        FileDataSource fileSource = savedDocument.getFileSource();
        Map<DataSegment, Long> saveMap = this.createSaveTransformation(savedDocument);
        for (DeltaDocument document : this.documents) {
            if (document == savedDocument) continue;
            this.applySaveMap(document, saveMap, fileSource);
        }
        DefaultDoublyLinkedList<DataSegment> segments = savedDocument.getSegments();
        LinkedList<DataArea> releasedSegments = new LinkedList<DataArea>();
        DataSegment segment = (DataSegment)segments.first();
        long segmentDocumentPosition = 0L;
        while (segment != null) {
            this.processSegmentForSave(segment, fileSource, segmentDocumentPosition, savedDocument, saveMap, releasedSegments);
            segment = savedDocument.getSegment(segmentDocumentPosition += segment.getLength());
        }
        while (!releasedSegments.isEmpty()) {
            long segmentPosition;
            DataArea dataArea = (DataArea)releasedSegments.remove(releasedSegments.size() - 1);
            DataSegment segment2 = savedDocument.getSegment(dataArea.startFrom);
            while (segment2 != null && (segmentPosition = saveMap.get(segment2).longValue()) <= dataArea.startFrom + dataArea.length) {
                DataSegment nextSegment = segment2.getNext();
                if (!(segment2 instanceof SpaceSegment)) {
                    long segmentDocumentPosition2 = saveMap.get(segment2);
                    this.processSegmentForSave(segment2, fileSource, segmentDocumentPosition2, savedDocument, saveMap, releasedSegments);
                }
                segment2 = nextSegment;
            }
        }
        segment = (DataSegment)segments.first();
        segmentDocumentPosition = 0L;
        while (segment != null) {
            if (!(segment instanceof SpaceSegment)) {
                long currentSegmentDocumentPosition = saveMap.get(segment);
                long currentSegmentLength = segment.getLength();
                long processed = 0L;
                while (currentSegmentLength > 0L) {
                    DataSegment nextSegment;
                    long length = currentSegmentLength;
                    if (length > 4096L) {
                        length = 4096L;
                    }
                    this.saveSegmentSection(currentSegmentDocumentPosition + processed, length, fileSource, saveMap, savedDocument);
                    if ((currentSegmentLength -= length) <= 0L || (nextSegment = savedDocument.getSegment(segmentDocumentPosition + (processed += length))) == null) continue;
                    saveMap.put(nextSegment, currentSegmentDocumentPosition + processed);
                }
            }
            segment = savedDocument.getSegment(segmentDocumentPosition += segment.getLength());
        }
        long fileLength = savedDocument.getDataSize();
        savedDocument.clear();
        FileSegment fullFileSegment = this.createFileSegment(fileSource, 0L, fileLength);
        savedDocument.getSegments().add(fullFileSegment);
        savedDocument.setDataLength(fileLength);
        fileSource.setFileLength(fileLength);
        fileSource.clearCache();
    }

    private void processSegmentForSave(DataSegment segment, FileDataSource fileSource, long segmentDocumentPosition, DeltaDocument savedDocument, Map<DataSegment, Long> saveMap, List<DataArea> releasedSegments) {
        boolean saveSegment = true;
        boolean hasOverlaps = this.hasFileOverlaps(segmentDocumentPosition, segment, fileSource);
        if (!hasOverlaps) {
            if (segment instanceof FileSegment) {
                FileSegment fileSegment = (FileSegment)segment;
                long segmentLength = segment.getLength();
                FileDataSource source = fileSegment.getSource();
                if (source == savedDocument.getFileSource() && segmentDocumentPosition == fileSegment.getStartPosition()) {
                    SpaceSegment spaceSegment = new SpaceSegment(segmentLength);
                    savedDocument.replaceSegment(segmentDocumentPosition, spaceSegment);
                    saveMap.put(spaceSegment, segmentDocumentPosition);
                    saveSegment = false;
                } else {
                    releasedSegments.add(new DataArea(segment.getStartPosition(), segmentLength));
                }
            }
            if (saveSegment) {
                this.saveSegment(fileSource, segmentDocumentPosition, segment);
                SpaceSegment spaceSegment = new SpaceSegment(segment.getLength());
                savedDocument.replaceSegment(segmentDocumentPosition, spaceSegment);
                saveMap.put(spaceSegment, segmentDocumentPosition);
            }
        }
    }

    private boolean hasFileOverlaps(long startPosition, DataSegment segment, FileDataSource fileSource) {
        DataSegmentsMap segmentsMap = this.fileSources.get(fileSource);
        SegmentRecord record = segmentsMap.focusFirstOverlay(startPosition, segment.getLength());
        while (record != null && record.getStartPosition() < startPosition + segment.getLength()) {
            if (record.dataSegment == segment || record.getStartPosition() + record.getLength() <= startPosition) {
                record = record.next;
                continue;
            }
            return true;
        }
        return false;
    }

    private void saveSegmentSection(long savePosition, long saveLength, FileDataSource fileSource, Map<DataSegment, Long> saveMap, DeltaDocument savedDocument) {
        long overlapLength;
        DataSegment segment = savedDocument.getSegment(savePosition);
        Long segmentSavePosition = saveMap.get(segment);
        if (segmentSavePosition == null) {
            throw new IllegalStateException("Unexpected missing save position");
        }
        long segmentDocumentPosition = segmentSavePosition;
        long sectionStart = savePosition - segmentDocumentPosition;
        DataSegmentsMap segmentsMap = this.fileSources.get(fileSource);
        SegmentRecord firstRecord = segmentsMap.focusFirstOverlay(segmentDocumentPosition + sectionStart, saveLength);
        while (!(firstRecord == null || saveMap.containsKey(firstRecord.dataSegment) && firstRecord.dataSegment != segment)) {
            firstRecord = firstRecord.next;
            if (firstRecord == null || firstRecord.getStartPosition() < segmentDocumentPosition + sectionStart + saveLength) continue;
            firstRecord = null;
            break;
        }
        if (firstRecord != null) {
            SegmentRecord record = firstRecord.next;
            if (record != null && record.getStartPosition() >= segmentDocumentPosition + sectionStart + saveLength) {
                record = null;
            }
            if (record != null) {
                record = segmentsMap.focusFirstOverlay(segmentDocumentPosition + sectionStart, saveLength);
                while (record != null && record.getStartPosition() < segmentDocumentPosition + sectionStart + saveLength) {
                    SegmentRecord nextRecord = record.next;
                    if (record.dataSegment != segment) {
                        long overlapLength2 = record.getLength();
                        long overlapStart = 0L;
                        if (segmentDocumentPosition + sectionStart > record.getStartPosition()) {
                            overlapStart = segmentDocumentPosition + sectionStart - record.getStartPosition();
                            overlapLength2 -= overlapStart;
                        }
                        if (record.getStartPosition() + overlapStart + overlapLength2 > segmentDocumentPosition + sectionStart + saveLength) {
                            overlapLength2 = segmentDocumentPosition + sectionStart + saveLength - firstRecord.getStartPosition() - overlapStart;
                        }
                        if (overlapLength2 > 0L) {
                            this.preloadSegmentSection(record.dataSegment, overlapStart, overlapLength2, fileSource, saveMap, savedDocument);
                        }
                    }
                    if ((record = nextRecord) != null) continue;
                    break;
                }
            } else {
                long overlapLength3 = firstRecord.getLength();
                long overlapStart = 0L;
                if (segmentDocumentPosition + sectionStart > firstRecord.getStartPosition()) {
                    overlapStart = segmentDocumentPosition + sectionStart - firstRecord.getStartPosition();
                    overlapLength3 -= overlapStart;
                }
                if (firstRecord.getStartPosition() + overlapStart + overlapLength3 > segmentDocumentPosition + sectionStart + saveLength) {
                    overlapLength3 = segmentDocumentPosition + sectionStart + saveLength - firstRecord.getStartPosition() - overlapStart;
                }
                if (overlapLength3 > 0L) {
                    long overlapPosition = saveMap.get(firstRecord.dataSegment);
                    this.preloadSegmentSection(firstRecord.dataSegment, overlapStart, overlapLength3, fileSource, saveMap, savedDocument);
                    this.saveSegmentSection(overlapPosition + overlapStart, overlapLength3, fileSource, saveMap, savedDocument);
                }
            }
        }
        long processed = 0L;
        for (long length = saveLength; length > 0L; length -= overlapLength) {
            DataSegment savedSegment = savedDocument.getSegment(savePosition + processed);
            long savedSegmentPosition = segmentDocumentPosition + processed;
            overlapLength = savedSegmentPosition + savedSegment.getLength() - savePosition;
            long overlapStart = savePosition - savedSegmentPosition;
            if (!(savedSegment instanceof SpaceSegment)) {
                DataSegment followingSegment;
                if (!(savedSegment instanceof FileSegment) || ((FileSegment)savedSegment).getSource() != fileSource || savedSegmentPosition != savedSegment.getStartPosition()) {
                    this.saveSegment(fileSource, savedSegmentPosition, savedSegment, overlapStart, overlapLength);
                }
                DataSegment originalSegment = savedDocument.getSegment(savedSegmentPosition + overlapStart);
                saveMap.remove(originalSegment);
                savedDocument.replaceSegment(savedSegmentPosition + overlapStart, new SpaceSegment(overlapLength));
                if (savedSegmentPosition + overlapStart + overlapLength < segment.getLength() && (followingSegment = savedDocument.getSegment(savedSegmentPosition + overlapStart + overlapLength)) != null) {
                    saveMap.put(followingSegment, savedSegmentPosition + overlapStart + overlapLength);
                }
            }
            processed += overlapLength;
        }
    }

    private void preloadSegmentSection(DataSegment segment, long sectionStart, long sectionLength, FileDataSource fileSource, Map<DataSegment, Long> saveMap, DeltaDocument savedDocument) {
        Long segmentDocumentPosition = saveMap.get(segment);
        if (segmentDocumentPosition == null) {
            return;
        }
        if (segment == null || !(segment instanceof FileSegment) || ((FileSegment)segment).getSource() != fileSource) {
            throw new IllegalArgumentException("Segment is not valid for preloading");
        }
        MemorySegment preloadedSegment = this.createMemorySegment();
        preloadedSegment.setLength(sectionLength);
        preloadedSegment.getSource().insert(0L, (BinaryData)savedDocument, segmentDocumentPosition + sectionStart, sectionLength);
        savedDocument.replaceSegment(segmentDocumentPosition + sectionStart, preloadedSegment);
        saveMap.put(preloadedSegment, segmentDocumentPosition + sectionStart);
        DataSegment afterSegment = savedDocument.getSegment(segmentDocumentPosition + sectionStart + sectionLength);
        if (afterSegment != null) {
            saveMap.put(afterSegment, segmentDocumentPosition + sectionStart + sectionLength);
        }
    }

    private void saveSegment(FileDataSource fileSource, long targetPosition, DataSegment segment) {
        this.saveSegment(fileSource, targetPosition, segment, 0L, segment.getLength());
    }

    private void saveSegment(FileDataSource fileSource, long targetPosition, DataSegment segment, long segmentOffset, long segmentLimit) {
        RandomAccessFile accessFile = fileSource.getAccessFile();
        try {
            if (segment instanceof MemorySegment) {
                int length;
                MemorySegment memorySegment = (MemorySegment)segment;
                MemoryDataSource source = memorySegment.getSource();
                accessFile.seek(targetPosition);
                long sectionPosition = memorySegment.getStartPosition() + segmentOffset;
                byte[] buffer = new byte[4096];
                for (long sectionLength = segmentLimit; sectionLength > 0L; sectionLength -= (long)length) {
                    length = sectionLength < 4096L ? (int)sectionLength : 4096;
                    source.copyToArray(sectionPosition, buffer, 0, length);
                    accessFile.write(buffer, 0, length);
                    sectionPosition += (long)length;
                }
            } else {
                FileSegment fileSegment = (FileSegment)segment;
                FileDataSource source = fileSegment.getSource();
                RandomAccessFile sourceFile = source.getAccessFile();
                long sectionPosition = fileSegment.getStartPosition() + segmentOffset;
                long sectionLength = segmentLimit;
                long sectionProcessed = 0L;
                if (source == fileSource && targetPosition > sectionPosition && sectionPosition + sectionLength >= targetPosition) {
                    byte[] buffer = new byte[4096];
                    while (sectionLength > 0L) {
                        int red;
                        int length;
                        sourceFile.seek(sectionPosition + sectionLength - (long)length);
                        for (int toProcess = length = sectionLength < 4096L ? (int)sectionLength : 4096; toProcess > 0; toProcess -= red) {
                            red = sourceFile.read(buffer, length - toProcess, toProcess);
                        }
                        accessFile.seek(targetPosition + sectionLength - (long)length);
                        accessFile.write(buffer, 0, length);
                        sectionLength -= (long)length;
                        sectionProcessed += (long)length;
                    }
                } else {
                    byte[] buffer = new byte[4096];
                    while (sectionLength > 0L) {
                        int length = sectionLength < 4096L ? (int)sectionLength : 4096;
                        sourceFile.seek(sectionPosition + sectionProcessed);
                        length = sourceFile.read(buffer, 0, length);
                        accessFile.seek(targetPosition + sectionProcessed);
                        accessFile.write(buffer, 0, length);
                        sectionLength -= (long)length;
                        sectionProcessed += (long)length;
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SegmentsRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    private Map<DataSegment, Long> createSaveTransformation(DeltaDocument savedDocument) {
        HashMap<DataSegment, Long> transformation = new HashMap<DataSegment, Long>();
        DefaultDoublyLinkedList<DataSegment> segments = savedDocument.getSegments();
        long position = 0L;
        for (DataSegment segment : segments) {
            transformation.put(segment, position);
            position += segment.getLength();
        }
        return transformation;
    }

    private void applySaveMap(DeltaDocument document, Map<DataSegment, Long> saveMap, FileDataSource fileSource) {
        DataSegmentsMap segmentsMap = this.fileSources.get(fileSource);
        long documentPosition = 0L;
        DataSegment segment = document.getSegment(0L);
        while (segment != null) {
            DataSegment nextSegment = segment.getNext();
            long segmentLength = segment.getLength();
            if (segment instanceof FileSegment && ((FileSegment)segment).getSource() == fileSource) {
                long segmentPosition = segment.getStartPosition();
                long segmentEnd = segmentPosition + segmentLength;
                long processed = 0L;
                SegmentRecord record = segmentsMap.focusFirstOverlay(segmentPosition, segmentLength);
                while (record != null && processed < segmentLength && record.getStartPosition() <= segmentEnd) {
                    Long savePosition = saveMap.get(record.dataSegment);
                    if (savePosition != null && record.getStartPosition() + record.getLength() >= segmentPosition + processed) {
                        long replacedLength = record.getLength();
                        long replacedPosition = record.getStartPosition();
                        if (segmentPosition > replacedPosition) {
                            replacedLength -= segmentPosition - replacedPosition;
                            replacedPosition = segmentPosition;
                        }
                        if (replacedPosition + replacedLength > segmentEnd) {
                            replacedLength = segmentEnd - replacedPosition;
                        }
                        if (replacedLength > 0L) {
                            long replacedOffset = replacedPosition - segmentPosition;
                            if (processed < replacedOffset) {
                                this.preloadDocumentSection(document, documentPosition + processed, replacedOffset - processed);
                            }
                            if (savePosition + replacedOffset != segmentPosition) {
                                FileSegment newSegment = this.createFileSegment(fileSource, savePosition + replacedOffset, replacedLength);
                                document.remove(documentPosition + replacedOffset, replacedLength);
                                document.insertSegment(documentPosition + replacedOffset, newSegment);
                            }
                            processed = replacedOffset + replacedLength;
                        }
                    }
                    if ((record = segmentsMap.records.nextTo(record)) != null) continue;
                    break;
                }
                if (processed < segmentLength) {
                    this.preloadDocumentSection(document, documentPosition + processed, segmentLength - processed);
                }
            }
            documentPosition += segmentLength;
            segment = nextSegment;
        }
        document.clearCache();
    }

    private void preloadDocumentSection(DeltaDocument document, long documentPosition, long sectionLength) {
        MemorySegment preloadedSegment = this.createMemorySegment();
        preloadedSegment.setLength(sectionLength);
        preloadedSegment.getSource().insert(0L, (BinaryData)document, documentPosition, sectionLength);
        document.replaceSegment(documentPosition, preloadedSegment);
    }

    @Nonnull
    public FileSegment createFileSegment(FileDataSource fileSource, long startPosition, long length) {
        FileSegment fileSegment = new FileSegment(fileSource, startPosition, length);
        DataSegmentsMap segmentsMap = this.fileSources.get(fileSource);
        segmentsMap.add(fileSegment);
        return fileSegment;
    }

    public void dropFileSegment(FileSegment fileSegment) {
        DataSegmentsMap segmentsMap = this.fileSources.get(fileSegment.getSource());
        segmentsMap.remove(fileSegment);
    }

    @Nonnull
    public MemorySegment createMemorySegment() {
        return this.createMemorySegment(this.openMemorySource(), 0L, 0L);
    }

    @Nonnull
    public MemorySegment createMemorySegment(MemoryDataSource memorySource, long startPosition, long length) {
        if (startPosition + length > memorySource.getDataSize()) {
            memorySource.setDataSize(startPosition + length);
        }
        MemorySegment memorySegment = new MemorySegment(memorySource, startPosition, length);
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        segmentsMap.add(memorySegment);
        return memorySegment;
    }

    @Nonnull
    public void updateSegment(DataSegment segment, long position, long length) {
        if (segment instanceof MemorySegment) {
            DataSegmentsMap segmentsMap = this.memorySources.get(((MemorySegment)segment).getSource());
            segmentsMap.updateSegment(segment, position, length);
        } else {
            DataSegmentsMap segmentsMap = this.fileSources.get(((FileSegment)segment).getSource());
            segmentsMap.updateSegment(segment, position, length);
        }
    }

    public void updateSegmentLength(DataSegment segment, long length) {
        if (segment instanceof MemorySegment) {
            DataSegmentsMap segmentsMap = this.memorySources.get(((MemorySegment)segment).getSource());
            segmentsMap.updateSegmentLength(segment, length);
        } else {
            DataSegmentsMap segmentsMap = this.fileSources.get(((FileSegment)segment).getSource());
            segmentsMap.updateSegmentLength(segment, length);
        }
    }

    public void dropMemorySegment(MemorySegment memorySegment) {
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySegment.getSource());
        segmentsMap.remove(memorySegment);
    }

    public void dropSegment(DataSegment segment) {
        if (segment instanceof FileSegment) {
            this.dropFileSegment((FileSegment)segment);
        } else if (segment instanceof MemorySegment) {
            this.dropMemorySegment((MemorySegment)segment);
        }
    }

    public void dropDocument(DeltaDocument document) {
        for (DataSegment segment : document.getSegments()) {
            this.dropSegment(segment);
        }
        document.clear();
        this.documents.remove(document);
    }

    public void setMemoryByte(MemorySegment memorySegment, long segmentPosition, byte value) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 1L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        if (segmentPosition >= memorySegment.getLength()) {
            segmentsMap.updateSegmentLength(memorySegment, segmentPosition + 1L);
            if (sourcePosition >= memorySource.getDataSize()) {
                memorySource.setDataSize(sourcePosition + 1L);
            }
        }
        memorySource.setByte(memorySegment.getStartPosition() + segmentPosition, value);
    }

    public void insertMemoryData(MemorySegment memorySegment, long segmentPosition, BinaryData insertedData) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, insertedData.getDataSize());
        memorySource.insert(sourcePosition, insertedData);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + insertedData.getDataSize());
    }

    public void insertMemoryData(MemorySegment memorySegment, long segmentPosition, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, insertedDataLength);
        memorySource.insert(sourcePosition, insertedData, insertedDataOffset, insertedDataLength);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + insertedDataLength);
    }

    public void insertMemoryData(MemorySegment memorySegment, long segmentPosition, byte[] insertedData) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, insertedData.length);
        memorySource.insert(sourcePosition, insertedData);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + (long)insertedData.length);
    }

    public void insertMemoryData(MemorySegment memorySegment, long segmentPosition, byte[] insertedData, int insertedDataOffset, int insertedDataLength) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, insertedDataLength);
        memorySource.insert(sourcePosition, insertedData, insertedDataOffset, insertedDataLength);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + (long)insertedDataLength);
    }

    public void insertMemoryData(MemorySegment memorySegment, long segmentPosition, long length) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, length);
        memorySource.insert(sourcePosition, length);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + length);
    }

    public void insertUninitializedMemoryData(MemorySegment memorySegment, long segmentPosition, long length) {
        MemoryDataSource memorySource = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySource);
        this.detachMemoryArea(memorySegment, segmentPosition, 0L);
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        this.shiftSegments(memorySegment, sourcePosition, length);
        memorySource.insertUninitialized(sourcePosition, length);
        segmentsMap.updateSegmentLength(memorySegment, memorySegment.getLength() + length);
    }

    public void detachMemoryArea(MemorySegment memorySegment, long segmentPosition, long length) {
        long sourcePosition = memorySegment.getStartPosition() + segmentPosition;
        DataSegmentsMap segmentsMap = this.memorySources.get(memorySegment.getSource());
        if (!segmentsMap.hasMoreSegments()) {
            return;
        }
        SegmentRecord record = segmentsMap.focusFirstOverlay(sourcePosition, length);
        while (record != null) {
            DataSegment segment;
            SegmentRecord nextRecord = record.getNext();
            if (record.getStartPosition() > sourcePosition + length) break;
            if (record.getStartPosition() + record.getLength() > sourcePosition && (segment = record.dataSegment) != memorySegment) {
                this.detachSegment((MemorySegment)segment);
            }
            record = nextRecord;
        }
    }

    public void detachSegment(MemorySegment memorySegment) {
        MemoryDataSource source = memorySegment.getSource();
        MemoryDataSource newMemorySource = this.openMemorySource();
        newMemorySource.insert(0L, source.copy(memorySegment.getStartPosition(), memorySegment.getLength()));
        DataSegmentsMap segmentsMap = this.memorySources.get(source);
        segmentsMap.remove(memorySegment);
        memorySegment.setSource(newMemorySource);
        DataSegmentsMap newSegmentsMap = this.memorySources.get(newMemorySource);
        newSegmentsMap.add(memorySegment);
    }

    private void shiftSegments(MemorySegment memorySegment, long position, long shift) {
        MemoryDataSource source = memorySegment.getSource();
        DataSegmentsMap segmentsMap = this.memorySources.get(source);
        SegmentRecord record = segmentsMap.focusFirstOverlay(position, source.getDataSize() - position);
        while (record != null) {
            SegmentRecord nextRecord = record.getNext();
            if (record.dataSegment != memorySegment && record.getStartPosition() >= position) {
                MemorySegment segment = (MemorySegment)record.dataSegment;
                segment.setStartPosition(segment.getStartPosition() + shift);
                record.maxPosition += shift;
            }
            record = nextRecord;
        }
    }

    @Nonnull
    public DataSegment copySegment(DataSegment segment) {
        if (segment instanceof MemorySegment) {
            MemorySegment memorySegment = (MemorySegment)segment;
            return this.createMemorySegment(memorySegment.getSource(), memorySegment.getStartPosition(), memorySegment.getLength());
        }
        FileSegment fileSegment = (FileSegment)segment;
        return this.createFileSegment(fileSegment.getSource(), fileSegment.getStartPosition(), fileSegment.getLength());
    }

    @Nonnull
    public DataSegment copySegment(DataSegment segment, long offset, long length) {
        if (segment instanceof MemorySegment) {
            MemorySegment memorySegment = (MemorySegment)segment;
            return this.createMemorySegment(memorySegment.getSource(), memorySegment.getStartPosition() + offset, length);
        }
        FileSegment fileSegment = (FileSegment)segment;
        return this.createFileSegment(fileSegment.getSource(), fileSegment.getStartPosition() + offset, length);
    }

    public void detachFileSource(FileDataSource fileSource) {
        for (DeltaDocument document : this.documents) {
            long segmentLength;
            for (long documentPosition = 0L; documentPosition < document.getDataSize(); documentPosition += segmentLength) {
                DataSegment segment = document.getSegment(documentPosition);
                segmentLength = segment.getLength();
                if (!(segment instanceof FileSegment) || ((FileSegment)segment).getSource() != fileSource) continue;
                this.preloadDocumentSection(document, documentPosition, segmentLength);
            }
        }
    }

    private static final class DataArea {
        long startFrom;
        long length;

        public DataArea(long startFrom, long length) {
            this.startFrom = startFrom;
            this.length = length;
        }
    }

    private static class SegmentRecord
    implements DoublyLinkedItem<SegmentRecord> {
        @Nullable
        SegmentRecord prev = null;
        @Nullable
        SegmentRecord next = null;
        @Nonnull
        DataSegment dataSegment;
        long maxPosition;

        private SegmentRecord() {
        }

        @Override
        @Nullable
        public SegmentRecord getNext() {
            return this.next;
        }

        public long getStartPosition() {
            return this.dataSegment.getStartPosition();
        }

        public long getLength() {
            return this.dataSegment.getLength();
        }

        @Override
        public void setNext(@Nullable SegmentRecord next) {
            this.next = next;
        }

        @Override
        @Nullable
        public SegmentRecord getPrev() {
            return this.prev;
        }

        @Override
        public void setPrev(@Nullable SegmentRecord prev) {
            this.prev = prev;
        }
    }

    @ParametersAreNonnullByDefault
    private class DataSegmentsMap {
        @Nonnull
        private final DefaultDoublyLinkedList<SegmentRecord> records = new DefaultDoublyLinkedList();
        @Nullable
        private SegmentRecord pointerRecord = null;

        private void add(DataSegment segment) {
            this.focusSegment(segment.getStartPosition(), segment.getLength());
            SegmentRecord record = new SegmentRecord();
            record.dataSegment = segment;
            this.addRecord(record);
        }

        private void addRecord(SegmentRecord record) {
            long startPosition = record.dataSegment.getStartPosition();
            long length = record.getLength();
            long maxPosition = startPosition + length;
            if (this.pointerRecord == null) {
                record.maxPosition = maxPosition;
                this.records.add(0, record);
                SegmentRecord nextRecord = record.next;
                while (nextRecord != null && nextRecord.maxPosition < maxPosition) {
                    nextRecord.maxPosition = maxPosition;
                    nextRecord = this.records.nextTo(nextRecord);
                }
            } else {
                if (this.pointerRecord.maxPosition > maxPosition) {
                    maxPosition = this.pointerRecord.maxPosition;
                } else {
                    SegmentRecord nextRecord = this.pointerRecord.next;
                    while (nextRecord != null && maxPosition > nextRecord.maxPosition) {
                        nextRecord.maxPosition = maxPosition;
                        nextRecord = this.records.nextTo(nextRecord);
                    }
                }
                record.maxPosition = maxPosition;
                this.records.addAfter(this.pointerRecord, record);
            }
        }

        private void remove(DataSegment segment) {
            SegmentRecord record = this.findRecord(segment);
            if (record.dataSegment != segment) {
                throw new IllegalStateException("Segment requested for removal was not found");
            }
            this.removeRecord(record);
        }

        private void removeRecord(SegmentRecord record) {
            SegmentRecord prevRecord = this.records.prevTo(record);
            SegmentRecord nextRecord = this.records.nextTo(record);
            long recordEndPosition = record.getStartPosition() + record.getLength();
            this.records.remove(record);
            this.pointerRecord = prevRecord;
            long prevMaxPosition = 0L;
            if (prevRecord != null) {
                prevMaxPosition = prevRecord.maxPosition;
            }
            if (nextRecord != null && prevMaxPosition < recordEndPosition) {
                long maxPosition = nextRecord.getStartPosition() + nextRecord.getLength();
                if (prevMaxPosition > maxPosition) {
                    maxPosition = prevMaxPosition;
                }
                while (nextRecord != null && maxPosition < nextRecord.maxPosition) {
                    long nextMaxPosition;
                    nextRecord.maxPosition = maxPosition;
                    if ((nextRecord = this.records.nextTo(nextRecord)) == null || (nextMaxPosition = nextRecord.getStartPosition() + nextRecord.getLength()) <= maxPosition) continue;
                    maxPosition = nextMaxPosition;
                }
            }
        }

        private boolean hasMoreSegments() {
            return this.records.first() != null && this.records.first() != this.records.last();
        }

        private void updateSegment(DataSegment segment, long position, long length) {
            SegmentRecord record = this.findRecord(segment);
            if (record.dataSegment == segment) {
                this.removeRecord(record);
                if (segment instanceof MemorySegment) {
                    ((MemorySegment)segment).setStartPosition(position);
                    ((MemorySegment)segment).setLength(length);
                } else {
                    ((FileSegment)segment).setStartPosition(position);
                    ((FileSegment)segment).setLength(length);
                }
            } else {
                throw new IllegalStateException("Segment requested for update was not found");
            }
            this.focusSegment(segment.getStartPosition(), segment.getLength());
            this.addRecord(record);
        }

        private void updateSegmentLength(DataSegment segment, long length) {
            SegmentRecord record = this.findRecord(segment);
            if (record.dataSegment == segment) {
                this.removeRecord(record);
                if (segment instanceof MemorySegment) {
                    ((MemorySegment)segment).setLength(length);
                } else {
                    ((FileSegment)segment).setLength(length);
                }
            } else {
                throw new IllegalStateException("Segment requested for update was not found");
            }
            this.focusSegment(segment.getStartPosition(), segment.getLength());
            this.addRecord(record);
        }

        @Nullable
        private SegmentRecord findRecord(DataSegment segment) {
            this.focusSegment(segment.getStartPosition(), segment.getLength());
            SegmentRecord record = this.pointerRecord;
            if (record == null) {
                return null;
            }
            while (record != null && record.dataSegment != segment && record.getStartPosition() == segment.getStartPosition() && record.getLength() == segment.getLength()) {
                record = this.records.prevTo(record);
            }
            return record;
        }

        private void focusSegment(long startPosition, long length) {
            if (this.pointerRecord == null) {
                this.pointerRecord = (SegmentRecord)this.records.first();
            }
            if (this.pointerRecord == null) {
                return;
            }
            if (this.pointerRecord.getStartPosition() < startPosition || this.pointerRecord.getStartPosition() == startPosition && this.pointerRecord.getLength() <= length) {
                SegmentRecord record;
                do {
                    if ((record = this.records.nextTo(this.pointerRecord)) == null) continue;
                    if (record.getStartPosition() >= startPosition && (record.getStartPosition() != startPosition || record.getLength() > length)) break;
                    this.pointerRecord = record;
                } while (record != null);
            } else {
                while (this.pointerRecord.getStartPosition() > startPosition || this.pointerRecord.getStartPosition() == startPosition && this.pointerRecord.getLength() > length) {
                    this.pointerRecord = this.records.prevTo(this.pointerRecord);
                    if (this.pointerRecord != null) continue;
                    break;
                }
            }
        }

        @Nullable
        private SegmentRecord focusFirstOverlay(long startPosition, long length) {
            if (this.pointerRecord == null) {
                this.pointerRecord = (SegmentRecord)this.records.first();
            }
            if (this.pointerRecord == null) {
                return null;
            }
            long endPosition = startPosition + length;
            if (this.pointerRecord.maxPosition < startPosition) {
                while (this.pointerRecord != null) {
                    SegmentRecord nextRecord = this.records.nextTo(this.pointerRecord);
                    if (nextRecord != null && nextRecord.maxPosition < startPosition) {
                        this.pointerRecord = nextRecord;
                        continue;
                    }
                    if (this.pointerRecord.getStartPosition() < endPosition) {
                        return this.pointerRecord;
                    }
                    break;
                }
            } else {
                while (this.pointerRecord != null) {
                    SegmentRecord nextRecord = this.records.prevTo(this.pointerRecord);
                    if (nextRecord != null && nextRecord.maxPosition >= startPosition) {
                        this.pointerRecord = nextRecord;
                        continue;
                    }
                    if (this.pointerRecord.getStartPosition() < endPosition) {
                        return this.pointerRecord;
                    }
                    break;
                }
            }
            return null;
        }
    }
}

