/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.OutOfBoundsException;
import org.exbin.auxiliary.binary_data.delta.DataSegment;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.auxiliary.binary_data.delta.FileSegment;
import org.exbin.auxiliary.binary_data.delta.MemorySegment;
import org.exbin.auxiliary.binary_data.delta.SegmentsRepository;
import org.exbin.auxiliary.binary_data.delta.list.DefaultDoublyLinkedList;

@ParametersAreNonnullByDefault
public class DeltaDocumentWindow {
    @Nonnull
    private final DeltaDocument document;
    private final DataPointer pointer = new DataPointer();

    public DeltaDocumentWindow(DeltaDocument document) {
        this.document = document;
        document.addChangeListener(window -> {
            if (window != this) {
                this.pointer.segment = window.pointer.segment;
                this.pointer.position = window.pointer.position;
            }
        });
    }

    public long getDataSize() {
        return this.document.getDataSize();
    }

    public byte getByte(long position) {
        this.focusSegment(position);
        DataSegment targetSegment = this.pointer.segment;
        if (targetSegment == null) {
            throw new NullPointerException("Missing segment for position " + position);
        }
        if (targetSegment instanceof FileSegment) {
            return ((FileSegment)targetSegment).getByte(targetSegment.getStartPosition() + (position - this.pointer.position));
        }
        return ((MemorySegment)targetSegment).getByte(targetSegment.getStartPosition() + (position - this.pointer.position));
    }

    public void setByte(long position, byte value) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(position);
        if (this.pointer.segment instanceof FileSegment) {
            DataSegment prev;
            if (this.pointer.position != position) {
                this.splitSegment(position);
                this.focusSegment(position);
            }
            if ((prev = segments.prevTo(this.pointer.segment)) instanceof MemorySegment) {
                repository.setMemoryByte((MemorySegment)prev, prev.getLength(), value);
            } else {
                MemorySegment segment = repository.createMemorySegment(repository.openMemorySource(), 0L, 0L);
                repository.setMemoryByte(segment, 0L, value);
                segments.addBefore(this.pointer.segment, segment);
            }
            ++this.pointer.position;
            FileSegment documentSegment = (FileSegment)this.pointer.segment;
            if (documentSegment.getLength() == 1L) {
                segments.remove(documentSegment);
                repository.dropSegment(documentSegment);
                this.pointer.position = 0L;
                this.pointer.segment = null;
            } else {
                repository.updateSegment(documentSegment, documentSegment.getStartPosition() + 1L, documentSegment.getLength() - 1L);
            }
        } else {
            if (this.pointer.segment == null) {
                this.pointer.segment = repository.createMemorySegment(repository.openMemorySource(), 0L, 0L);
                segments.add(this.pointer.segment);
            }
            repository.setMemoryByte((MemorySegment)this.pointer.segment, position - this.pointer.position, value);
        }
        if (position >= this.getDataSize()) {
            this.document.setDataLength(position + 1L);
        }
        this.document.notifyChangeListeners(this);
    }

    public void insertUninitialized(long startFrom, long length) {
        if (length == 0L) {
            return;
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + length;
        if (this.pointer.segment instanceof MemorySegment) {
            repository.insertUninitializedMemoryData((MemorySegment)this.pointer.segment, startFrom - this.pointer.position, length);
            this.document.setDataLength(targetLength);
        } else if (this.pointer.segment != null && this.pointer.position == startFrom && this.pointer.segment.getPrev() instanceof MemorySegment && this.pointer.segment.getPrev().getStartPosition() + this.pointer.segment.getPrev().getLength() == ((MemorySegment)this.pointer.segment.getPrev()).getSource().getDataSize()) {
            MemorySegment prevSegment = (MemorySegment)this.pointer.segment.getPrev();
            prevSegment.getSource().insertUninitialized(prevSegment.getSource().getDataSize(), length);
            repository.updateSegmentLength(prevSegment, prevSegment.getLength() + length);
            ++this.pointer.position;
            this.document.setDataLength(targetLength);
        } else if (this.pointer.segment == null && segments.last() instanceof MemorySegment && ((DataSegment)segments.last()).getStartPosition() + ((DataSegment)segments.last()).getLength() == ((MemorySegment)segments.last()).getSource().getDataSize()) {
            MemorySegment prevSegment = (MemorySegment)segments.last();
            prevSegment.getSource().insertUninitialized(prevSegment.getSource().getDataSize(), length);
            repository.updateSegmentLength(prevSegment, prevSegment.getLength() + length);
            ++this.pointer.position;
            this.document.setDataLength(targetLength);
        } else {
            if (startFrom > this.pointer.position) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertUninitializedMemoryData(insertedSegment, 0L, length);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, length);
        }
        this.document.notifyChangeListeners(this);
    }

    public void insert(long startFrom, long length) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        if (length == 0L) {
            return;
        }
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + length;
        if (this.pointer.segment instanceof MemorySegment) {
            repository.insertMemoryData((MemorySegment)this.pointer.segment, startFrom - this.pointer.position, length);
            this.document.setDataLength(targetLength);
        } else if (this.pointer.segment != null && this.pointer.position == startFrom && this.pointer.segment.getPrev() instanceof MemorySegment && this.pointer.segment.getPrev().getStartPosition() + this.pointer.segment.getPrev().getLength() == ((MemorySegment)this.pointer.segment.getPrev()).getSource().getDataSize()) {
            MemorySegment prevSegment = (MemorySegment)this.pointer.segment.getPrev();
            prevSegment.getSource().insert(prevSegment.getSource().getDataSize(), length);
            repository.updateSegmentLength(prevSegment, prevSegment.getLength() + length);
            ++this.pointer.position;
            this.document.setDataLength(targetLength);
        } else if (this.pointer.segment == null && segments.last() instanceof MemorySegment && ((DataSegment)segments.last()).getStartPosition() + ((DataSegment)segments.last()).getLength() == ((MemorySegment)segments.last()).getSource().getDataSize()) {
            MemorySegment prevSegment = (MemorySegment)segments.last();
            prevSegment.getSource().insert(prevSegment.getSource().getDataSize(), length);
            repository.updateSegmentLength(prevSegment, prevSegment.getLength() + length);
            ++this.pointer.position;
            this.document.setDataLength(targetLength);
        } else {
            if (startFrom > this.pointer.position) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertMemoryData(insertedSegment, 0L, length);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, length);
        }
        this.document.notifyChangeListeners(this);
    }

    public void insert(long startFrom, byte[] insertedData) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        if (insertedData.length == 0) {
            return;
        }
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + (long)insertedData.length;
        if (this.pointer.segment instanceof MemorySegment) {
            repository.insertMemoryData((MemorySegment)this.pointer.segment, startFrom - this.pointer.position, insertedData);
            this.document.setDataLength(targetLength);
        } else {
            if (startFrom > this.pointer.position) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertMemoryData(insertedSegment, 0L, insertedData);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.length);
        }
        this.document.notifyChangeListeners(this);
    }

    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int insertedDataLength) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + (long)insertedDataLength;
        if (this.pointer.segment instanceof MemorySegment) {
            repository.insertMemoryData((MemorySegment)this.pointer.segment, startFrom - this.pointer.position, insertedData);
            this.document.setDataLength(targetLength);
        } else {
            if (startFrom > this.pointer.position) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertMemoryData(insertedSegment, 0L, insertedData);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.length);
        }
        this.document.notifyChangeListeners(this);
    }

    public void insert(long startFrom, BinaryData insertedData) {
        if (insertedData.isEmpty()) {
            return;
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + insertedData.getDataSize();
        if (insertedData instanceof DeltaDocument) {
            DataSegment copy;
            if (this.pointer.position < startFrom) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            DeltaDocument insertedDocument = (DeltaDocument)insertedData;
            DataSegment segment = (DataSegment)insertedDocument.getSegments().first();
            DataSegment first = copy = repository.copySegment(segment);
            if (this.pointer.segment == null) {
                segments.add(copy);
            } else {
                segments.addBefore(this.pointer.segment, copy);
            }
            for (DataSegment next = segment.getNext(); next != null; next = next.getNext()) {
                DataSegment nextCopy = repository.copySegment(next);
                segments.addAfter(copy, nextCopy);
                copy = nextCopy;
            }
            this.pointer.segment = first;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.getDataSize());
        } else if (this.pointer.segment instanceof MemorySegment) {
            repository.insertMemoryData((MemorySegment)this.pointer.segment, startFrom - this.pointer.position, insertedData);
            this.document.setDataLength(targetLength);
        } else {
            if (this.pointer.position < startFrom) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertMemoryData(insertedSegment, 0L, insertedData);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.getDataSize());
        }
        this.document.notifyChangeListeners(this);
    }

    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        if (insertedDataLength == 0L) {
            return;
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(startFrom);
        long targetLength = this.document.getDataSize() + insertedDataLength;
        if (insertedData instanceof DeltaDocument) {
            if (this.pointer.position < startFrom) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            DeltaDocument insertedDocument = (DeltaDocument)insertedData;
            long position = insertedDataOffset;
            long length = insertedDataLength;
            DataSegment segment = insertedDocument.getPartCopy(position, length);
            position += segment.getLength();
            length -= segment.getLength();
            DataSegment first = segment;
            if (this.pointer.segment == null) {
                segments.add(segment);
            } else {
                segments.addBefore(this.pointer.segment, segment);
            }
            DataSegment next = segment.getNext();
            while (length > 0L) {
                DataSegment nextSegment = insertedDocument.getPartCopy(position, length);
                position += nextSegment.getLength();
                length -= nextSegment.getLength();
                segments.addAfter(segment, nextSegment);
                segment = nextSegment;
                next = next.getNext();
            }
            this.pointer.segment = first;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.getDataSize());
        } else {
            if (this.pointer.position < startFrom) {
                this.splitSegment(startFrom);
                this.focusSegment(startFrom);
            }
            MemorySegment insertedSegment = repository.createMemorySegment();
            repository.insertMemoryData(insertedSegment, 0L, insertedData, insertedDataOffset, insertedDataLength);
            if (this.pointer.segment == null) {
                segments.add(insertedSegment);
            } else {
                segments.addBefore(this.pointer.segment, insertedSegment);
            }
            this.pointer.segment = insertedSegment;
            this.document.setDataLength(targetLength);
            this.tryMergeArea(startFrom, insertedData.getDataSize());
        }
        this.document.notifyChangeListeners(this);
    }

    public void insertSegment(long startFrom, DataSegment insertedSegment) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        long targetLength = this.document.getDataSize() + insertedSegment.getLength();
        this.focusSegment(startFrom);
        if (this.pointer.position < startFrom) {
            this.splitSegment(startFrom);
            this.focusSegment(startFrom);
        }
        if (this.pointer.segment == null) {
            segments.add(insertedSegment);
        } else {
            segments.addBefore(this.pointer.segment, insertedSegment);
        }
        this.pointer.segment = insertedSegment;
        this.document.setDataLength(targetLength);
        this.document.notifyChangeListeners(this);
    }

    public void remove(long startFrom, long length) {
        if (startFrom + length > this.document.getDataSize()) {
            throw new OutOfBoundsException("Removed area is out of bounds");
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        if (length > 0L) {
            long prevPointerPosition;
            long targetLength = this.document.getDataSize() - length;
            this.focusSegment(startFrom + length);
            this.splitSegment(startFrom + length);
            this.focusSegment(startFrom);
            this.splitSegment(startFrom);
            this.focusSegment(startFrom);
            DataSegment prevSegment = this.pointer.segment.getPrev();
            long l = prevPointerPosition = prevSegment == null ? 0L : this.pointer.position - prevSegment.getLength();
            while (length > 0L) {
                length -= this.pointer.segment.getLength();
                DataSegment next = segments.nextTo(this.pointer.segment);
                repository.dropSegment(this.pointer.segment);
                segments.remove(this.pointer.segment);
                this.pointer.segment = next;
            }
            this.pointer.segment = prevSegment;
            this.pointer.position = prevPointerPosition;
            this.document.setDataLength(targetLength);
            this.tryMergeSegments(startFrom);
        }
        this.document.notifyChangeListeners(this);
    }

    public void reset() {
        this.pointer.setPointer(0L, (DataSegment)this.document.getSegments().first());
    }

    public void setDataSize(long dataSize) {
        this.document.setDataSize(dataSize);
    }

    @Nonnull
    public BinaryData copy() {
        SegmentsRepository repository = this.document.getRepository();
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        DeltaDocument copy = repository.createDocument();
        copy.setDataLength(this.getDataSize());
        for (DataSegment segment : segments) {
            copy.getSegments().add(repository.copySegment(segment));
        }
        return copy;
    }

    @Nonnull
    public BinaryData copy(long startFrom, long length) {
        SegmentsRepository repository = this.document.getRepository();
        DeltaDocument copy = repository.createDocument();
        copy.setDataLength(length);
        this.focusSegment(startFrom);
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        DataSegment segment = this.pointer.segment;
        if (segment == null) {
            throw new NullPointerException("Segment on given position not found");
        }
        long offset = startFrom - this.pointer.position;
        while (length > 0L) {
            long segmentLength = segment.getLength();
            long copyLength = segmentLength - offset;
            if (copyLength > length) {
                copyLength = length;
            }
            if (offset == 0L && copyLength == segmentLength) {
                copy.getSegments().add(repository.copySegment(segment));
            } else if (segment instanceof MemorySegment) {
                MemorySegment memorySegment = (MemorySegment)segment;
                copy.getSegments().add(repository.createMemorySegment(memorySegment.getSource(), memorySegment.getStartPosition() + offset, copyLength));
            } else {
                FileSegment fileSegment = (FileSegment)segment;
                copy.getSegments().add(repository.createFileSegment(fileSegment.getSource(), fileSegment.getStartPosition() + offset, copyLength));
            }
            offset = 0L;
            segment = segments.nextTo(segment);
            if ((length -= copyLength) <= 0L || segment != null) continue;
            throw new NullPointerException("Unexpected end of segments sequence");
        }
        return copy;
    }

    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        this.document.copyToArray(startFrom, target, offset, length);
    }

    public void splitSegment(long position) {
        long pointerPosition = this.pointer.position;
        DataSegment pointerSegment = this.pointer.segment;
        if (position < pointerPosition || pointerSegment != null && position > pointerPosition + pointerSegment.getLength()) {
            throw new IllegalStateException("Split position is out of current segment");
        }
        if (pointerPosition == position || pointerSegment == null || pointerPosition + pointerSegment.getLength() == position) {
            return;
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        long firstPartSize = position - pointerPosition;
        if (pointerSegment instanceof MemorySegment) {
            MemorySegment memorySegment = (MemorySegment)pointerSegment;
            MemorySegment newSegment = repository.createMemorySegment(memorySegment.getSource(), memorySegment.getStartPosition() + firstPartSize, memorySegment.getLength() - firstPartSize);
            repository.updateSegmentLength(memorySegment, firstPartSize);
            segments.addAfter(pointerSegment, newSegment);
        } else {
            FileSegment fileSegment = (FileSegment)pointerSegment;
            FileSegment newSegment = repository.createFileSegment(fileSegment.getSource(), fileSegment.getStartPosition() + firstPartSize, fileSegment.getLength() - firstPartSize);
            repository.updateSegmentLength(fileSegment, firstPartSize);
            segments.addAfter(fileSegment, newSegment);
        }
    }

    @Nullable
    public DataSegment getSegment(long position) {
        this.focusSegment(position);
        return this.pointer.segment;
    }

    @Nullable
    public DataSegment getPartCopy(long position, long length) {
        this.focusSegment(position);
        if (this.pointer.segment == null) {
            return null;
        }
        SegmentsRepository repository = this.document.getRepository();
        long offset = position - this.pointer.position;
        long partLength = length;
        if (this.pointer.segment.getLength() - offset < partLength) {
            partLength = this.pointer.segment.getLength() - offset;
        }
        return repository.copySegment(this.pointer.segment, offset, partLength);
    }

    private void focusSegment(long position) {
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        long dataSize = this.getDataSize();
        if (position == 0L) {
            this.pointer.position = 0L;
            this.pointer.segment = (DataSegment)segments.first();
            return;
        }
        if (position == dataSize) {
            this.pointer.position = dataSize;
            this.pointer.segment = null;
            return;
        }
        if (position < 0L || position > dataSize) {
            throw new OutOfBoundsException("Position index out of range");
        }
        if (this.pointer.segment == null) {
            this.pointer.segment = (DataSegment)segments.last();
            this.pointer.position = dataSize - this.pointer.segment.getLength();
        }
        if (position < this.pointer.position) {
            if (this.pointer.segment == null && position == dataSize) {
                this.pointer.segment = (DataSegment)segments.last();
                if (this.pointer.segment == null) {
                    DeltaDocumentWindow.throwNullSegmentException();
                }
                this.pointer.position -= this.pointer.segment.getLength();
            }
            while (position < this.pointer.position) {
                this.pointer.segment = segments.prevTo(this.pointer.segment);
                if (this.pointer.segment == null) {
                    DeltaDocumentWindow.throwNullSegmentException();
                }
                this.pointer.position -= this.pointer.segment.getLength();
            }
        } else {
            if (this.pointer.segment == null) {
                DeltaDocumentWindow.throwNullSegmentException();
            }
            while (position >= this.pointer.position + this.pointer.segment.getLength() && (this.pointer.segment.getNext() != null || position != this.pointer.position + this.pointer.segment.getLength())) {
                this.pointer.position += this.pointer.segment.getLength();
                this.pointer.segment = segments.nextTo(this.pointer.segment);
                if (this.pointer.segment != null) continue;
                DeltaDocumentWindow.throwNullSegmentException();
            }
        }
    }

    private void tryMergeArea(long position, long length) {
        this.tryMergeSegments(position);
        this.tryMergeSegments(position + length);
    }

    private boolean tryMergeSegments(long position) {
        if (position == 0L || position >= this.getDataSize()) {
            return false;
        }
        DefaultDoublyLinkedList<DataSegment> segments = this.document.getSegments();
        SegmentsRepository repository = this.document.getRepository();
        this.focusSegment(position);
        DataSegment nextSegment = this.pointer.segment;
        this.focusSegment(position - 1L);
        DataSegment segment = this.pointer.segment;
        if (segment == nextSegment) {
            return false;
        }
        if (segment instanceof FileSegment && nextSegment instanceof FileSegment) {
            if (((FileSegment)segment).getStartPosition() + segment.getLength() == ((FileSegment)nextSegment).getStartPosition()) {
                repository.updateSegmentLength(segment, segment.getLength() + nextSegment.getLength());
                repository.dropSegment(nextSegment);
                segments.remove(nextSegment);
                return true;
            }
            return false;
        }
        if (segment instanceof MemorySegment && nextSegment instanceof MemorySegment) {
            MemorySegment memorySegment = (MemorySegment)segment;
            MemorySegment nextMemorySegment = (MemorySegment)nextSegment;
            if (memorySegment.getSource() == nextMemorySegment.getSource() && memorySegment.getStartPosition() + segment.getLength() == nextMemorySegment.getStartPosition()) {
                repository.updateSegmentLength(memorySegment, segment.getLength() + nextSegment.getLength());
                repository.dropSegment(nextSegment);
                segments.remove(nextSegment);
                return true;
            }
        }
        return false;
    }

    public void validatePointerPosition() {
        if (this.pointer.segment == null) {
            if (this.pointer.position > 0L && this.pointer.position < this.getDataSize()) {
                throw new IllegalStateException("Illegal pointer position " + this.pointer.position + " for null segment");
            }
        } else {
            long segmentsLengthSum = 0L;
            for (DataSegment segment = this.pointer.segment.getPrev(); segment != null; segment = segment.getPrev()) {
                segmentsLengthSum += segment.getLength();
            }
            if (segmentsLengthSum != this.pointer.position) {
                throw new IllegalStateException("Illegal pointer position " + this.pointer.position);
            }
        }
    }

    private static void throwNullSegmentException() {
        throw new IllegalStateException("Unexpected null segment");
    }

    private static class DataPointer {
        long position;
        @Nullable
        DataSegment segment;

        private DataPointer() {
        }

        void setPointer(long position, @Nullable DataSegment segment) {
            this.position = position;
            this.segment = segment;
        }
    }
}

