/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.FinishableStream;
import org.exbin.auxiliary.binary_data.SeekableStream;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.auxiliary.binary_data.delta.DeltaDocumentWindow;

@ParametersAreNonnullByDefault
public class DeltaDocumentInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final DeltaDocumentWindow data;
    private long position = 0L;
    private long mark = 0L;

    public DeltaDocumentInputStream(DeltaDocument document) {
        this.data = new DeltaDocumentWindow(document);
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.data.getDataSize()) {
            return -1;
        }
        try {
            int value = this.data.getByte(this.position) & 0xFF;
            ++this.position;
            return value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        if (output.length == 0 || length == 0) {
            return 0;
        }
        long dataSize = this.data.getDataSize();
        if (this.position >= dataSize) {
            return -1;
        }
        if (this.position + (long)length > dataSize) {
            length = (int)(dataSize - this.position);
        }
        this.data.copyToArray(this.position, output, offset, length);
        this.position += (long)length;
        return length;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        long available = this.data.getDataSize() - this.position;
        return available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)available;
    }

    public void seek(long position) throws IOException {
        this.position = position;
    }

    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    public long getProcessedSize() {
        return this.position;
    }

    public long getStreamSize() {
        return this.data.getDataSize();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        long dataSize = this.data.getDataSize();
        if (this.position + n < dataSize) {
            this.position += n;
            return n;
        }
        long skipped = dataSize - this.position;
        this.position = dataSize;
        return skipped;
    }
}

