/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.delta;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.delta.FileDataSource;

@ParametersAreNonnullByDefault
public class DeltaDataPageWindow {
    public static final int PAGE_SIZE = 1024;
    @Nonnull
    private final FileDataSource data;
    @Nonnull
    private final DataPage[] dataPages = new DataPage[]{new DataPage(), new DataPage()};
    private int activeDataPage = 1;

    public DeltaDataPageWindow(FileDataSource data) {
        this.data = data;
        this.dataPages[0].pageIndex = 0L;
        this.loadPage(0);
        data.addCacheClearListener(() -> this.clearCache());
    }

    private void loadPage(int index) {
        long pageIndex = this.dataPages[index].pageIndex;
        long pagePosition = pageIndex * 1024L;
        RandomAccessFile file = this.data.getAccessFile();
        try {
            long fileLength = file.length();
            byte[] page = this.dataPages[index].page;
            int offset = 0;
            int toRead = 1024;
            if (pagePosition + 1024L > fileLength) {
                toRead = (int)(fileLength - pagePosition);
            }
            file.seek(pagePosition);
            while (toRead > 0) {
                int red = file.read(page, offset, toRead);
                if (red == -1) {
                    throw new IOException("Unexpected read error ");
                }
                toRead -= red;
                offset += red;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DeltaDataPageWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public byte getByte(long position) {
        long targetPageIndex = position / 1024L;
        int index = -1;
        long pageIndex1 = this.dataPages[0].pageIndex;
        long pageIndex2 = this.dataPages[1].pageIndex;
        if (pageIndex1 == targetPageIndex) {
            index = 0;
        } else if (pageIndex2 == targetPageIndex) {
            index = 1;
        }
        if (index == -1) {
            DataPage dataPage = this.dataPages[this.activeDataPage];
            dataPage.pageIndex = targetPageIndex;
            this.loadPage(this.activeDataPage);
            this.activeDataPage = this.activeDataPage + 1 & 1;
            return dataPage.page[(int)(position % 1024L)];
        }
        return this.dataPages[index].page[(int)(position % 1024L)];
    }

    public void clearCache() {
        this.dataPages[0].pageIndex = -1L;
        this.dataPages[1].pageIndex = -1L;
    }

    private static class DataPage {
        long pageIndex = -1L;
        byte[] page = new byte[1024];
    }
}

