/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.options.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.wave.options.impl.AudioDevicesOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class AudioDevicesOptionsPanel
extends JPanel
implements OptionsComponent<AudioDevicesOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AudioDevicesOptionsPanel.class);
    public JPanel audioOutputPanel;
    public JLabel outputBufferSizeLabel;
    public JComboBox<String> outputSampleRateComboBox;
    public JLabel outputSampleRateLabel;
    public JComboBox<String> outputSoundDeviceComboBox;
    public JLabel outputSoundDeviceLabel;
    public JButton testAudioButton;

    public AudioDevicesOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        Mixer.Info[] mis;
        for (Mixer.Info mi : mis = AudioSystem.getMixerInfo()) {
            Control[] cs;
            Line.Info[] lis;
            Mixer mixer = AudioSystem.getMixer(mi);
            for (Line.Info info : lis = mixer.getSourceLineInfo()) {
            }
            lis = mixer.getTargetLineInfo();
            this.outputSoundDeviceComboBox.addItem(mixer.getMixerInfo().getName());
            for (Line.Info li : lis) {
                Mixer.Info info = mixer.getMixerInfo();
            }
            for (Control c : cs = mixer.getControls()) {
                System.out.println("    control: " + c.toString());
            }
        }
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(AudioDevicesOptionsImpl options) {
    }

    public void saveToOptions(AudioDevicesOptionsImpl options) {
    }

    private void initComponents() {
        this.audioOutputPanel = new JPanel();
        this.outputSoundDeviceLabel = new JLabel();
        this.outputSampleRateLabel = new JLabel();
        this.outputBufferSizeLabel = new JLabel();
        this.outputSoundDeviceComboBox = new JComboBox();
        this.outputSampleRateComboBox = new JComboBox();
        JComboBox<String> outputBufferSizeComboBox = new JComboBox<String>();
        this.testAudioButton = new JButton();
        this.setAutoscrolls(true);
        this.audioOutputPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("audioOutputPanel.border.title")));
        this.audioOutputPanel.setName("audioOutputPanel");
        this.outputSoundDeviceLabel.setText(this.resourceBundle.getString("outputSoundDeviceLabel.text"));
        this.outputSoundDeviceLabel.setName("outputSoundDeviceLabel");
        this.outputSampleRateLabel.setText(this.resourceBundle.getString("outputSampleRateLabel.text"));
        this.outputSampleRateLabel.setName("outputSampleRateLabel");
        this.outputBufferSizeLabel.setText(this.resourceBundle.getString("outputBufferSizeLabel.text"));
        this.outputBufferSizeLabel.setName("outputBufferSizeLabel");
        this.outputSoundDeviceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.outputSoundDeviceComboBox.setName("outputSoundDeviceComboBox");
        this.outputSampleRateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.outputSampleRateComboBox.setName("outputSampleRateComboBox");
        outputBufferSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        outputBufferSizeComboBox.setName("outputBufferSizeComboBox");
        this.testAudioButton.setText(this.resourceBundle.getString("testAudioButton.text"));
        this.testAudioButton.setName("testAudioButton");
        GroupLayout audioOutputPanelLayout = new GroupLayout(this.audioOutputPanel);
        this.audioOutputPanel.setLayout(audioOutputPanelLayout);
        audioOutputPanelLayout.setHorizontalGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audioOutputPanelLayout.createSequentialGroup().addContainerGap().addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audioOutputPanelLayout.createSequentialGroup().addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputSoundDeviceLabel).addComponent(this.outputSampleRateLabel).addComponent(this.outputBufferSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputSampleRateComboBox, 0, 347, Short.MAX_VALUE).addComponent(this.outputSoundDeviceComboBox, 0, 347, Short.MAX_VALUE).addComponent(outputBufferSizeComboBox, 0, 347, Short.MAX_VALUE))).addComponent(this.testAudioButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        audioOutputPanelLayout.setVerticalGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(audioOutputPanelLayout.createSequentialGroup().addContainerGap().addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSoundDeviceLabel).addComponent(this.outputSoundDeviceComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputSampleRateLabel).addComponent(this.outputSampleRateComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(audioOutputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputBufferSizeLabel).addComponent(outputBufferSizeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.testAudioButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.audioOutputPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.audioOutputPanel, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AudioDevicesOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

