/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.command.WaveClipboardData;
import org.exbin.framework.editor.wave.command.WaveCopyCommand;
import org.exbin.framework.editor.wave.command.WaveCutCommand;
import org.exbin.framework.editor.wave.command.WaveDeleteCommand;
import org.exbin.framework.editor.wave.command.WavePasteCommand;
import org.exbin.framework.editor.wave.command.WaveReverseCommand;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.audio.wave.XBWave;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class AudioPanel
extends JPanel
implements ClipboardActionsHandler {
    private XBUndoHandler undoHandler;
    private boolean wavePlayed = false;
    private int drawPosition = -1;
    private int wavePosition = -1;
    private final PlayThread playThread = new PlayThread();
    private final WavePaintThread wavePaintThread = new WavePaintThread();
    private Color[] defaultColors;
    private XBWavePanel wavePanel;
    private SourceDataLine sourceDataLine;
    private AudioInputStream audioInputStream;
    private AudioFormat targetFormat;
    private DataLine.Info targetDataLineInfo;
    private int dataLinePosition;
    private InputMethodListener caretListener;
    private final List<StatusChangeListener> statusChangeListeners = new ArrayList<StatusChangeListener>();
    private final List<WaveRepaintListener> waveRepaintListeners = new ArrayList<WaveRepaintListener>();
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    private JScrollBar scrollBar;

    public AudioPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.wavePanel = new XBWavePanel();
        this.wavePanel.setSelectionChangedListener(() -> {
            if (this.clipboardActionsUpdateListener != null) {
                this.clipboardActionsUpdateListener.stateChanged();
            }
        });
        this.wavePanel.setZoomChangedListener(() -> this.scrollBar.setMaximum(this.wavePanel.getWaveWidth()));
        this.sourceDataLine = null;
        this.defaultColors = this.getAudioPanelColors();
        this.add((Component)this.wavePanel);
        this.scrollBar.addAdjustmentListener(evt -> {
            int valuePosition = evt.getValue();
            if (this.wavePlayed) {
                if ((int)((double)this.wavePosition * this.wavePanel.getScaleRatio()) != valuePosition) {
                    this.seekPlaying((int)((double)valuePosition / this.wavePanel.getScaleRatio()));
                }
            } else if (this.wavePosition != valuePosition) {
                this.wavePanel.setWindowPosition(valuePosition < 0 ? 0 : (int)((double)valuePosition / this.wavePanel.getScaleRatio()));
                this.repaint();
            }
        });
        this.playThread.start();
        this.wavePaintThread.start();
        this.targetDataLineInfo = null;
        this.audioInputStream = null;
    }

    public void performCopy() {
        XBWavePanel.SelectionRange selectionRange = this.wavePanel.getSelection();
        WaveCopyCommand copyCommand = new WaveCopyCommand(this.wavePanel, selectionRange.getBegin(), selectionRange.getEnd());
        copyCommand.execute();
    }

    public void performCut() {
        XBWavePanel.SelectionRange selectionRange = this.wavePanel.getSelection();
        WaveCutCommand cutCommand = new WaveCutCommand(this.wavePanel, selectionRange.getBegin(), selectionRange.getEnd());
        try {
            this.undoHandler.execute((Command)cutCommand);
        }
        catch (Exception ex) {
            Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.wavePanel.clearSelection();
    }

    public void performDelete() {
        XBWavePanel.SelectionRange selectionRange = this.wavePanel.getSelection();
        WaveDeleteCommand deleteCommand = new WaveDeleteCommand(this.wavePanel, selectionRange.getBegin(), selectionRange.getEnd());
        try {
            this.undoHandler.execute((Command)deleteCommand);
        }
        catch (Exception ex) {
            Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.wavePanel.clearSelection();
    }

    public void performPaste() {
        WavePasteCommand pasteCommand = new WavePasteCommand(this.wavePanel, this.wavePanel.getCursorPosition());
        try {
            this.undoHandler.execute((Command)pasteCommand);
        }
        catch (Exception ex) {
            Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.wavePanel.clearSelection();
    }

    public void performSelectAll() {
        this.wavePanel.selectAll();
    }

    @Nullable
    public XBWave getWave() {
        return this.wavePanel.getWave();
    }

    public void newWave() {
        this.wavePanel.setWave(null);
        this.scrollBar.setMaximum(this.wavePanel.getWaveWidth());
        this.undoHandler.clear();
    }

    public void setWave(XBWave wave) {
        this.wavePanel.setWave(wave);
        this.scrollBar.setMaximum(this.wavePanel.getWaveWidth());
        this.targetFormat = this.wavePanel.getWave().getAudioFormat();
        this.targetDataLineInfo = new DataLine.Info(SourceDataLine.class, this.wavePanel.getWave().getAudioFormat());
        this.audioInputStream = this.wavePanel.getWave().getAudioInputStream();
        if (!AudioSystem.isLineSupported(this.targetDataLineInfo)) {
            AudioFormat pcm = new AudioFormat(this.targetFormat.getSampleRate(), 16, this.targetFormat.getChannels(), true, false);
            this.audioInputStream = AudioSystem.getAudioInputStream(pcm, this.audioInputStream);
            this.targetFormat = this.audioInputStream.getFormat();
            this.targetDataLineInfo = new DataLine.Info(SourceDataLine.class, this.targetFormat);
        }
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(this.targetDataLineInfo);
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(AudioEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.wavePanel.setCursorPosition(0);
        this.wavePanel.setWindowPosition(0);
        this.wavePanel.repaint();
    }

    public boolean isModified() {
        return this.undoHandler.getCommandPosition() != this.undoHandler.getSyncPoint();
    }

    public void notifyFileSaved() {
        this.undoHandler.setSyncPoint();
    }

    public void performPlay() {
        this.wavePlay();
        this.notifyStatusChangeListeners();
    }

    public void performStop() {
        this.waveStop();
        this.notifyStatusChangeListeners();
    }

    private void wavePlay() {
        if (this.isPlaying()) {
            this.stopPlaying();
        } else {
            this.stopPlaying();
            this.startPlaying();
        }
    }

    private void waveStop() {
        if (this.isPlaying()) {
            this.stopPlaying();
        }
        this.wavePanel.setCursorPosition(0);
        this.wavePanel.setWindowPosition(0);
        this.wavePanel.repaint();
    }

    public int repaintWave() {
        int position = (int)this.playThread.getFramePosition();
        if (position > 0 && position != this.drawPosition) {
            return this.repaintOnPosition(position);
        }
        return -1;
    }

    private int repaintOnPosition(int position) {
        int screenWidth;
        this.drawPosition = position;
        int waveWidth = this.wavePanel.getWaveLength();
        int windowPosition = position > waveWidth - (screenWidth = (int)((double)this.getWidth() / this.wavePanel.getScaleRatio())) ? waveWidth - screenWidth : position - screenWidth / 2;
        if (windowPosition < 0) {
            windowPosition = 0;
        }
        this.wavePanel.setWindowPosition(windowPosition);
        this.wavePanel.setCursorPosition(position);
        this.wavePanel.repaint();
        this.notifyWaveRepaintListeners();
        return windowPosition;
    }

    private boolean isPlaying() {
        return this.playThread.playing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void playingChange(boolean play, boolean stop, int position) {
        if (this.wavePanel.getWave() != null) {
            this.wavePaintThread.terminated = true;
            this.wavePaintThread.terminate();
        }
        if (stop && this.wavePanel.getWave() != null) {
            this.wavePaintThread.terminate();
            this.playThread.terminated = true;
            this.sourceDataLine.stop();
            this.playThread.terminate();
        }
        if (stop && play) {
            this.repaintOnPosition(position);
        }
        if (play && this.wavePanel.getWave() != null) {
            this.dataLinePosition = this.wavePanel.getCursorPosition();
            if (this.dataLinePosition >= this.wavePanel.getWave().getLengthInTicks()) {
                this.dataLinePosition = 0;
            }
            Thread thread = this.playThread;
            synchronized (thread) {
                this.playThread.bufferPosition = this.dataLinePosition < 0 ? 0 : this.dataLinePosition * this.targetFormat.getFrameSize();
                this.playThread.playing = true;
                this.playThread.notify();
            }
            this.drawPosition = this.dataLinePosition;
            thread = this.wavePaintThread;
            synchronized (thread) {
                this.wavePaintThread.drawing = true;
                this.wavePaintThread.notify();
            }
        }
    }

    private void startPlaying() {
        this.playingChange(true, false, 0);
    }

    private void stopPlaying() {
        this.playingChange(false, true, 0);
    }

    private void seekPlaying(int position) {
        this.playingChange(true, true, position);
    }

    public void printFile() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog()) {
            try {
                job.setPrintable((graphics, pageFormat, pageIndex) -> {
                    if (pageIndex == 0) {
                        return 0;
                    }
                    return 1;
                });
                job.print();
            }
            catch (PrinterException ex) {
                Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Color[] getAudioPanelColors() {
        Color[] colors = new Color[]{this.wavePanel.getWaveColor(), this.wavePanel.getWaveFillColor(), this.wavePanel.getCursorColor(), this.wavePanel.getCursorWaveColor(), this.wavePanel.getBackground(), this.wavePanel.getSelectionColor()};
        return colors;
    }

    public void setAudioPanelColors(Color[] colors) {
        this.wavePanel.setWaveColor(colors[0]);
        this.wavePanel.setWaveFillColor(colors[1]);
        this.wavePanel.setCursorColor(colors[2]);
        this.wavePanel.setCursorWaveColor(colors[3]);
        this.wavePanel.setBackground(colors[4]);
        this.wavePanel.setSelectionColor(colors[5]);
        this.wavePanel.repaint();
    }

    private void initComponents() {
        this.scrollBar = new JScrollBar();
        this.setAutoscrolls(true);
        this.setInheritsPopupMenu(true);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.scrollBar.setBlockIncrement(40);
        this.scrollBar.setMaximum(0);
        this.scrollBar.setOrientation(0);
        this.scrollBar.setName("scrollBar");
        this.add((Component)this.scrollBar, "South");
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.wavePanel.setComponentPopupMenu(menu);
    }

    public void setScale(double ratio) {
        this.wavePanel.setScaleRatio(ratio);
        this.scrollBar.setMaximum(this.wavePanel.getWaveWidth());
        this.wavePanel.repaint();
    }

    public void scaleAndSeek(double ratio) {
        int windowPosition = this.wavePanel.getWindowPosition();
        if ((windowPosition = (int)((double)windowPosition / (this.wavePanel.getScaleRatio() / ratio)) - this.wavePanel.getWidth() / 2) < 0) {
            windowPosition = 0;
        }
        this.setScale(ratio);
        this.wavePanel.setWindowPosition(windowPosition);
        this.wavePanel.repaint();
    }

    public double getScale() {
        return this.wavePanel.getScaleRatio();
    }

    @Override
    public Point getMousePosition() {
        return this.wavePanel.getMousePosition();
    }

    public void attachCaretListener(MouseMotionListener listener) {
        this.wavePanel.addMouseMotionListener(listener);
    }

    public String getPositionTime() {
        Point point = this.getMousePosition();
        int position = point == null ? this.wavePanel.getCursorPosition() : point.x + this.wavePanel.getWindowPosition();
        return AudioPanel.getTimeForTicks(position, this.wavePanel.getWave());
    }

    public Color[] getDefaultColors() {
        return this.defaultColors;
    }

    public void setVolume(int value) {
        if (this.sourceDataLine != null && this.sourceDataLine.isOpen()) {
            FloatControl control = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
            control.setValue(control.getMinimum() * (1.0f - (float)Math.sqrt((float)value / 100.0f)));
        }
    }

    public boolean getIsPlaying() {
        return this.isPlaying();
    }

    public void setDrawMode(XBWavePanel.DrawMode drawMode) {
        this.wavePanel.setDrawMode(drawMode);
    }

    public void setToolMode(XBWavePanel.ToolMode toolMode) {
        this.wavePanel.setToolMode(toolMode);
        this.wavePanel.repaint();
    }

    public void performTransformReverse() {
        WaveReverseCommand waveReverseCommand;
        if (this.isSelection()) {
            XBWavePanel.SelectionRange selectionRange = this.wavePanel.getSelection();
            waveReverseCommand = new WaveReverseCommand(this.wavePanel, selectionRange.getBegin(), selectionRange.getEnd());
        } else {
            waveReverseCommand = new WaveReverseCommand(this.wavePanel);
        }
        try {
            this.undoHandler.execute((Command)waveReverseCommand);
        }
        catch (Exception ex) {
            Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isSelection() {
        return this.wavePanel.hasSelection() && this.wavePanel.getWave() != null;
    }

    public boolean isEditable() {
        return this.wavePanel.getWave() != null;
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canDelete() {
        return this.isEditable();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
        this.clipboardActionsUpdateListener = updateListener;
    }

    public boolean canPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        return clipboard.isDataFlavorAvailable(WaveClipboardData.WAVE_FLAVOR);
    }

    public boolean isEmpty() {
        return this.wavePanel.getWave() == null;
    }

    private static void showFormats(Line.Info li) {
        if (li instanceof DataLine.Info) {
            AudioFormat[] afs;
            for (AudioFormat af : afs = ((DataLine.Info)li).getFormats()) {
                System.out.println("        " + af.toString());
            }
        }
    }

    public static void main(String[] args) {
        Mixer.Info[] mis;
        for (Mixer.Info mi : mis = AudioSystem.getMixerInfo()) {
            Control[] cs;
            Line.Info[] lis;
            Mixer mixer = AudioSystem.getMixer(mi);
            System.out.println("mixer: " + mixer.getClass().getName());
            for (Line.Info li : lis = mixer.getSourceLineInfo()) {
                System.out.println("    source line: " + li.toString());
                AudioPanel.showFormats(li);
            }
            for (Line.Info li : lis = mixer.getTargetLineInfo()) {
                System.out.println("    target line: " + li.toString());
                AudioPanel.showFormats(li);
            }
            for (Control c : cs = mixer.getControls()) {
                System.out.println("    control: " + c.toString());
            }
        }
    }

    public AudioFormat getWaveFormat() {
        return this.wavePanel.getWave().getAudioFormat();
    }

    public String getWaveLength() {
        return AudioPanel.getTimeForTicks(this.wavePanel.getWave().getLengthInTicks(), this.wavePanel.getWave());
    }

    public void addStatusChangeListener(StatusChangeListener listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeStatusChangeListener(StatusChangeListener listener) {
        this.statusChangeListeners.remove(listener);
    }

    private void notifyStatusChangeListeners() {
        this.statusChangeListeners.stream().map(listener -> {
            if (this.wavePlayed != this.isPlaying()) {
                this.wavePlayed = !this.wavePlayed;
            }
            return listener;
        }).forEachOrdered(listener -> listener.statusChanged());
    }

    public void addWaveRepaintListener(WaveRepaintListener listener) {
        this.waveRepaintListeners.add(listener);
    }

    public void removeWaveRepaintListener(WaveRepaintListener listener) {
        this.waveRepaintListeners.remove(listener);
    }

    private void notifyWaveRepaintListeners() {
        this.waveRepaintListeners.forEach(listener -> listener.waveRepaint());
    }

    public static String getTimeForTicks(int position, XBWave wave) {
        String sec;
        if (wave == null) {
            return "0:00.00";
        }
        float sampleRate = wave.getAudioFormat().getSampleRate();
        float adjustedPosition = (float)position / sampleRate;
        String sub = String.valueOf((long)(((double)adjustedPosition - Math.floor(adjustedPosition)) * 100.0));
        if (sub.length() < 2) {
            sub = "0" + sub;
        }
        if ((sec = String.valueOf((long)adjustedPosition % 60L)).length() < 2) {
            sec = "0" + sec;
        }
        return String.valueOf((long)adjustedPosition / 60L) + ":" + sec + "." + sub;
    }

    public static interface WaveRepaintListener
    extends EventListener {
        public void waveRepaint();
    }

    public static interface StatusChangeListener
    extends EventListener {
        public void statusChanged();
    }

    class WavePaintThread
    extends Thread {
        boolean terminated;
        boolean drawing;

        WavePaintThread() {
        }

        @Override
        public void run() {
            this.terminated = false;
            this.drawing = false;
            this.mainLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mainLoop() {
            while (true) {
                try {
                    while (true) {
                        WavePaintThread wavePaintThread = this;
                        synchronized (wavePaintThread) {
                            this.wait();
                        }
                        this.terminated = false;
                        while (!this.terminated) {
                            WavePaintThread.sleep(50L);
                            if (this.terminated) continue;
                            AudioPanel.this.wavePosition = AudioPanel.this.repaintWave();
                            if (AudioPanel.this.wavePosition < 0) continue;
                            AudioPanel.this.scrollBar.setValue((int)((double)AudioPanel.this.wavePosition * AudioPanel.this.wavePanel.getScaleRatio()));
                        }
                        this.drawing = false;
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }

        private void terminate() {
            while (this.drawing) {
                try {
                    this.terminated = true;
                    WavePaintThread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    class PlayThread
    extends Thread {
        boolean playing;
        boolean terminated;
        int bufferPosition;

        PlayThread() {
        }

        @Override
        public void run() {
            this.playing = false;
            this.terminated = false;
            this.mainLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mainLoop() {
            block7: while (true) {
                try {
                    while (true) {
                        PlayThread playThread = this;
                        synchronized (playThread) {
                            this.wait();
                        }
                        this.terminated = false;
                        int bufferLength = AudioPanel.this.wavePanel.getWave().getPageSize() / 6;
                        try {
                            AudioPanel.this.sourceDataLine.open(AudioPanel.this.targetFormat, bufferLength);
                            AudioPanel.this.sourceDataLine.start();
                            byte[] buffer = new byte[bufferLength];
                            DataLine.Info info = new DataLine.Info(SourceDataLine.class, AudioPanel.this.wavePanel.getWave().getAudioFormat(), bufferLength);
                            boolean bIsSupportedDirectly = AudioSystem.isLineSupported(info);
                            AudioPanel.this.audioInputStream = AudioPanel.this.wavePanel.getWave().getAudioInputStream();
                            AudioPanel.this.audioInputStream.skip(this.bufferPosition);
                            if (!bIsSupportedDirectly || AudioPanel.this.wavePanel.getWave().getAudioFormat().getSampleSizeInBits() != 16) {
                                AudioPanel.this.audioInputStream = AudioSystem.getAudioInputStream(AudioPanel.this.targetFormat, AudioPanel.this.audioInputStream);
                            }
                            bufferLength = AudioPanel.this.audioInputStream.read(buffer, 0, bufferLength);
                            int offset = 0;
                            while (buffer != null && !this.terminated && bufferLength > offset) {
                                this.bufferPosition += bufferLength - offset;
                                AudioPanel.this.sourceDataLine.write(buffer, offset, bufferLength - offset);
                                bufferLength = AudioPanel.this.audioInputStream.read(buffer, 0, bufferLength);
                                offset = 0;
                            }
                            AudioPanel.this.sourceDataLine.drain();
                            AudioPanel.this.sourceDataLine.flush();
                            AudioPanel.this.sourceDataLine.close();
                            this.playing = false;
                            if (this.terminated) continue block7;
                            AudioPanel.this.wavePanel.setCursorPosition(AudioPanel.this.wavePanel.getWaveLength());
                            AudioPanel.this.notifyStatusChangeListeners();
                            continue block7;
                        }
                        catch (IOException | LineUnavailableException ex) {
                            Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }

        private long getFramePosition() {
            return this.bufferPosition / AudioPanel.this.targetFormat.getFrameSize();
        }

        private void terminate() {
            while (this.playing) {
                try {
                    this.terminated = true;
                    PlayThread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AudioPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

