/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.command;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.wave.command.WaveClipboardData;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.audio.wave.XBWave;

@ParametersAreNonnullByDefault
public class WaveCopyCommand {
    private final Clipboard clipboard;
    private final XBWavePanel wave;
    private final int startPosition;
    private final int endPosition;

    public WaveCopyCommand(XBWavePanel wave, int startPosition, int endPosition) {
        this.wave = wave;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public void execute() {
        XBWave copiedWave = this.wave.getWave().copy(this.startPosition, this.endPosition - this.startPosition);
        WaveClipboardData clipboardData = new WaveClipboardData(copiedWave);
        this.clipboard.setContents(clipboardData, clipboardData);
    }
}

