/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ZoomControlActions {
    public static final String NORMAL_ZOOM_ACTION_ID = "normalZoomAction";
    public static final String ZOOM_UP_ACTION_ID = "zoomUpAction";
    public static final String ZOOM_DOWN_ACTION_ID = "zoomDownAction";
    public static final String ZOOM_RADIO_GROUP_ID = "zoomRadioGroup";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action normalZoomAction;
    private Action zoomUpAction;
    private Action zoomDownAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getNormalZoomAction() {
        if (this.normalZoomAction == null) {
            this.normalZoomAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = ZoomControlActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.scaleAndSeek(1.0);
                }
            };
            ActionUtils.setupAction((Action)this.normalZoomAction, (ResourceBundle)this.resourceBundle, (String)NORMAL_ZOOM_ACTION_ID);
        }
        return this.normalZoomAction;
    }

    @Nonnull
    public Action getZoomUpAction() {
        if (this.zoomUpAction == null) {
            this.zoomUpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = ZoomControlActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.scaleAndSeek(audioPanel.getScale() / 2.0);
                }
            };
            ActionUtils.setupAction((Action)this.zoomUpAction, (ResourceBundle)this.resourceBundle, (String)ZOOM_UP_ACTION_ID);
        }
        return this.zoomUpAction;
    }

    @Nonnull
    public Action getZoomDownAction() {
        if (this.zoomDownAction == null) {
            this.zoomDownAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = ZoomControlActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.scaleAndSeek(audioPanel.getScale() * 2.0);
                }
            };
            ActionUtils.setupAction((Action)this.zoomDownAction, (ResourceBundle)this.resourceBundle, (String)ZOOM_DOWN_ACTION_ID);
        }
        return this.zoomDownAction;
    }
}

