/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.xbup.audio.swing.XBWavePanel;

@ParametersAreNonnullByDefault
public class EditToolActions {
    public static final String SELECTION_TOOL_ACTION_ID = "selectionToolAction";
    public static final String PENCIL_TOOL_ACTION_ID = "pencilToolAction";
    public static final String TOOLS_SELECTION_RADIO_GROUP_ID = "toolsSelectionRadioGroup";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action selectionToolAction;
    private Action pencilToolAction;
    private XBWavePanel.ToolMode toolMode = XBWavePanel.ToolMode.SELECTION;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    public void setToolMode(XBWavePanel.ToolMode mode) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        audioPanel.setToolMode(mode);
    }

    @Nonnull
    public Action getSelectionToolAction() {
        if (this.selectionToolAction == null) {
            this.selectionToolAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditToolActions.this.editorProvider instanceof AudioEditor) {
                        EditToolActions.this.setToolMode(XBWavePanel.ToolMode.SELECTION);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.selectionToolAction, (ResourceBundle)this.resourceBundle, (String)SELECTION_TOOL_ACTION_ID);
            this.selectionToolAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.selectionToolAction.putValue("radioGroup", TOOLS_SELECTION_RADIO_GROUP_ID);
            this.selectionToolAction.putValue("SwingSelectedKey", this.toolMode == XBWavePanel.ToolMode.SELECTION);
        }
        return this.selectionToolAction;
    }

    @Nonnull
    public Action getPencilToolAction() {
        if (this.pencilToolAction == null) {
            this.pencilToolAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditToolActions.this.editorProvider instanceof AudioEditor) {
                        EditToolActions.this.setToolMode(XBWavePanel.ToolMode.PENCIL);
                    }
                }
            };
            ActionUtils.setupAction((Action)this.pencilToolAction, (ResourceBundle)this.resourceBundle, (String)PENCIL_TOOL_ACTION_ID);
            this.pencilToolAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.pencilToolAction.putValue("radioGroup", TOOLS_SELECTION_RADIO_GROUP_ID);
            this.pencilToolAction.putValue("SwingSelectedKey", this.toolMode == XBWavePanel.ToolMode.PENCIL);
        }
        return this.pencilToolAction;
    }
}

