/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.utils.DesktopUtils;

@ParametersAreNonnullByDefault
public enum GuiRenderingMethod {
    DEFAULT(""),
    DIRECT_DRAW("directdraw"),
    DDRAW_HWSCALE("hw_scale"),
    SOFTWARE("software"),
    OPEN_GL("opengl"),
    XRENDER("xrender"),
    METAL("metal");

    private final String propertyValue;

    private GuiRenderingMethod(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Nonnull
    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Nonnull
    public static Optional<GuiRenderingMethod> fromPropertyValue(String propertyValue) {
        for (GuiRenderingMethod method : GuiRenderingMethod.values()) {
            if (!propertyValue.equals(method.getPropertyValue())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Nonnull
    public static List<GuiRenderingMethod> getAvailableMethods() {
        ArrayList<GuiRenderingMethod> methods = new ArrayList<GuiRenderingMethod>();
        DesktopUtils.DesktopOs desktopOs = DesktopUtils.detectBasicOs();
        methods.add(DEFAULT);
        methods.add(SOFTWARE);
        switch (desktopOs) {
            case WINDOWS: {
                methods.add(DIRECT_DRAW);
                methods.add(DDRAW_HWSCALE);
                methods.add(OPEN_GL);
                break;
            }
            case MAC_OS: {
                methods.add(OPEN_GL);
                methods.add(METAL);
                break;
            }
            default: {
                methods.add(OPEN_GL);
                methods.add(XRENDER);
            }
        }
        return methods;
    }
}

