/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.demo.slrub1;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.xbup.demo.slrub1.LRUB1;

public class LRUB1DemoForm
extends JFrame {
    private final LRUB1 handler = new LRUB1();
    private JButton closeButton;
    private JLabel codesLabel;
    private JScrollPane codesScrollPane;
    private JTextArea codesTextArea;
    private JButton convertFromButton;
    private JLabel convertFromLabel;
    private JButton convertToButton;
    private JLabel convertToLabel;
    private JButton listButton;
    private JTextField sourceCodeTextField;
    private JTextField sourceNumberTextField;
    private JTextField targetCodeTextField;
    private JTextField targetNumberTextField;

    public LRUB1DemoForm() {
        this.initComponents();
    }

    private void initComponents() {
        this.convertToLabel = new JLabel();
        this.sourceNumberTextField = new JTextField();
        this.convertToButton = new JButton();
        this.targetCodeTextField = new JTextField();
        this.convertFromLabel = new JLabel();
        this.sourceCodeTextField = new JTextField();
        this.convertFromButton = new JButton();
        this.targetNumberTextField = new JTextField();
        this.codesScrollPane = new JScrollPane();
        this.codesTextArea = new JTextArea();
        this.codesLabel = new JLabel();
        this.listButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("UBNumberDemo");
        this.convertToLabel.setText("Convert number to LRUB(1)");
        this.convertToButton.setText("Convert >>");
        this.convertToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LRUB1DemoForm.this.convertToButtonActionPerformed(evt);
            }
        });
        this.convertFromLabel.setText("Convert LRUB(1) code to number");
        this.sourceCodeTextField.setToolTipText("");
        this.convertFromButton.setText("Convert >>");
        this.convertFromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LRUB1DemoForm.this.convertFromButtonActionPerformed(evt);
            }
        });
        this.codesTextArea.setColumns(20);
        this.codesTextArea.setRows(5);
        this.codesScrollPane.setViewportView(this.codesTextArea);
        this.codesLabel.setText("List Codes");
        this.listButton.setText("List");
        this.listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LRUB1DemoForm.this.listButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LRUB1DemoForm.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.codesScrollPane, GroupLayout.Alignment.LEADING, -1, 442, Short.MAX_VALUE).addComponent(this.convertToLabel, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourceNumberTextField, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.convertToButton)).addGroup(layout.createSequentialGroup().addComponent(this.sourceCodeTextField, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.convertFromButton)).addComponent(this.convertFromLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.targetNumberTextField, -1, 153, Short.MAX_VALUE).addComponent(this.targetCodeTextField, GroupLayout.Alignment.LEADING, -1, 153, Short.MAX_VALUE))).addComponent(this.codesLabel, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.listButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 309, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.convertToLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceNumberTextField, -2, -1, -2).addComponent(this.targetCodeTextField, -2, -1, -2).addComponent(this.convertToButton)).addGap(18, 18, 18).addComponent(this.convertFromLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetNumberTextField, -2, -1, -2).addComponent(this.sourceCodeTextField, -2, -1, -2).addComponent(this.convertFromButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.codesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codesScrollPane, -1, 183, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.listButton)).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void convertToButtonActionPerformed(ActionEvent evt) {
        this.targetCodeTextField.setText("");
        try {
            long value = Long.parseLong(this.sourceNumberTextField.getText());
            this.targetCodeTextField.setText(this.handler.codeFromNumber(value));
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Input String is not valid " + ex.getMessage(), "Input String is not valid", 0);
        }
    }

    private void listButtonActionPerformed(ActionEvent evt) {
        StringBuilder builder = new StringBuilder();
        for (long value = 0L; value < 50000L; ++value) {
            builder.append(this.handler.codeFromNumber(value));
            builder.append("        = ");
            builder.append(String.valueOf(value));
            builder.append(System.getProperty("line.separator"));
        }
        this.codesTextArea.setText(builder.toString());
    }

    private void convertFromButtonActionPerformed(ActionEvent evt) {
        this.targetNumberTextField.setText("");
        try {
            long value = this.handler.numberFromCode(this.sourceCodeTextField.getText());
            this.targetNumberTextField.setText(String.valueOf(value));
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Input String is not valid " + ex.getMessage(), "Input String is not valid", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LRUB1DemoForm().setVisible(true);
            }
        });
    }
}

