/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.update;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.convert.XBCatalogXb;
import org.exbin.xbup.client.XBCatalogNetServiceClient;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.stub.XBPRootStub;
import org.exbin.xbup.client.update.XBCUpdateHandler;
import org.exbin.xbup.client.update.XBCUpdateListener;

@ParametersAreNonnullByDefault
public class XBCatalogServiceUpdateHandler
implements XBCUpdateHandler {
    private final List<XBCUpdateListener> updateListeners = new ArrayList<XBCUpdateListener>();
    private final XBCatalogNetServiceClient serviceClient;
    private final XBAECatalog catalog;

    public XBCatalogServiceUpdateHandler(XBAECatalog catalog, XBCatalogNetServiceClient serviceClient) {
        this.catalog = catalog;
        this.serviceClient = serviceClient;
    }

    public void init() {
    }

    @Nonnull
    public Date getMainLastUpdate() {
        XBPRootStub rootStub = new XBPRootStub((XBCatalogServiceClient)this.serviceClient);
        return (Date)rootStub.getMainLastUpdate().get();
    }

    public void performUpdateMain() {
        XBPRootStub rootStub = new XBPRootStub((XBCatalogServiceClient)this.serviceClient);
        InputStream stream = rootStub.getMainRootExport();
        XBCatalogXb catalogXb = new XBCatalogXb();
        catalogXb.setCatalog(this.catalog);
        catalogXb.importFromXbStream(stream);
    }

    public void performUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addUpdateListener(XBCUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(XBCUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void fireUsageEvent(boolean usage) {
        this.updateListeners.forEach(listener -> listener.webServiceUsage(usage));
    }
}

