/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXStri;
import org.exbin.xbup.catalog.entity.manager.XBEXStriManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.manager.XBCXStriManager;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBEXStriService
extends XBEDefaultService<XBCXStri>
implements XBCXStriService,
Serializable {
    @Autowired
    private XBEXStriManager manager;

    public XBEXStriService() {
    }

    public XBEXStriService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBEXStriManager(catalog);
        catalog.addCatalogManager(XBCXStriManager.class, (XBCXStriManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public String getItemStringIdText(XBCItem item) {
        return ((XBEXStriManager)this.itemManager).getItemStringIdText(item);
    }

    public XBEXStri getItemStringId(XBCItem item) {
        return ((XBEXStriManager)this.itemManager).getItemStringId(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public void setItemStringIdText(XBCItem item, String text) {
        XBEXStri stringId = this.getItemStringId(item);
        if (text == null || text.isEmpty()) {
            if (stringId != null) {
                this.removeItem(stringId);
            }
        } else {
            if (stringId == null) {
                stringId = (XBEXStri)this.createItem();
                stringId.setItem(item);
            }
            stringId.setText(text);
            this.persistItem(stringId);
        }
    }

    public String getFullPath(XBCXStri itemString) {
        return ((XBEXStriManager)this.itemManager).getFullPath(itemString);
    }

    public String getItemFullPath(XBCItem item) {
        XBEXStri stri = this.getItemStringId(item);
        if (stri == null) {
            return null;
        }
        return this.getFullPath(stri);
    }

    public XBCSpec getSpecByFullPath(String fullPath) {
        return ((XBEXStriManager)this.itemManager).getSpecByFullPath(fullPath);
    }
}

