/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockRev;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUiType;
import org.exbin.xbup.catalog.entity.XBEXPlugin;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.manager.XBCXUiManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEXUiManager
extends XBEDefaultCatalogManager<XBCXBlockUi>
implements XBCXUiManager,
Serializable {
    public XBEXUiManager() {
    }

    public XBEXUiManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEXBlockUi.class;
    }

    public void initializeExtension() {
    }

    @Nonnull
    public String getExtensionName() {
        return "UI Extension";
    }

    public XBEXBlockUi findById(long id) {
        try {
            return (XBEXBlockUi)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXBlockUi as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEXPlugUiType findTypeById(long id) {
        try {
            return (XBEXPlugUiType)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugUiType as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Nonnull
    public List<XBCXBlockUi> getUis(XBCBlockRev rev) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXBlockUi as o WHERE o.blockRev.id = " + ((XBEBlockRev)rev).getId()).getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public List<XBCXBlockUi> getUis(XBCBlockRev rev, XBPlugUiType type) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXBlockUi as o WHERE o.blockRev.id = " + ((XBEBlockRev)rev).getId() + " AND o.plugUi.uiType.id = " + type.getDbIndex()).getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    public long getUisCount(XBCBlockRev rev) {
        if (!(rev instanceof XBEBlockRev)) {
            return 0L;
        }
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXBlockUi as o WHERE o.blockRev.id = " + ((XBEBlockRev)rev).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getUisCount(XBCBlockRev rev, XBPlugUiType type) {
        if (!(rev instanceof XBEBlockRev)) {
            return 0L;
        }
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXBlockUi as o WHERE o.blockRev.id = " + ((XBEBlockRev)rev).getId() + " AND o.plugUi.uiType.id = " + type.getDbIndex()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public XBEXBlockUi findUiByPR(XBCBlockRev rev, XBPlugUiType type, long priority) {
        if (!(rev instanceof XBEBlockRev)) {
            return null;
        }
        try {
            return (XBEXBlockUi)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXBlockUi as o WHERE o.blockRev.id = " + ((XBEBlockRev)rev).getId() + " AND o.priority = " + Long.toString(priority) + " AND o.plugUi.uiType.id = " + type.getDbIndex()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Nonnull
    public List<XBCXPlugUi> getPlugUis(XBCXPlugin plugin) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugUi as o WHERE o.plugin.id = " + ((XBEXPlugin)plugin).getId()).getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public List<XBCXPlugUi> getPlugUis(XBCXPlugin plugin, XBPlugUiType type) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugUi as o WHERE o.plugin.id = " + ((XBEXPlugin)plugin).getId() + " AND o.uiType.id = " + type.getDbIndex()).getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    public long getPlugUisCount(XBCXPlugin plugin) {
        if (!(plugin instanceof XBEXPlugin)) {
            return 0L;
        }
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXPlugUi as o WHERE o.plugin.id = " + ((XBEXPlugin)plugin).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getPlugUisCount(XBCXPlugin plugin, XBPlugUiType type) {
        if (!(plugin instanceof XBEXPlugin)) {
            return 0L;
        }
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXPlugUi as o WHERE o.plugin.id = " + ((XBEXPlugin)plugin).getId() + " AND o.uiType.id = " + type.getDbIndex()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public XBEXPlugUi getPlugUi(XBCXPlugin plugin, XBPlugUiType type, long methodIndex) {
        if (!(plugin instanceof XBEXPlugin)) {
            return null;
        }
        try {
            return (XBEXPlugUi)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugUi as o WHERE o.plugin.id = " + ((XBEXPlugin)plugin).getId() + " AND o.methodIndex = " + Long.toString(methodIndex) + " AND o.uiType.id = " + type.getDbIndex()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getAllPlugUisCount() {
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXPlugUi as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public XBEXPlugUi findPlugUiById(long id) {
        try {
            return (XBEXPlugUi)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugUi as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXUiManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public boolean initCatalog() {
        XBEDefaultCatalogManager<XBEXPlugUiType> plugUiTypeManager = new XBEDefaultCatalogManager<XBEXPlugUiType>(this.catalog){

            @Override
            public Class getEntityClass() {
                return XBEXPlugUiType.class;
            }
        };
        for (int i = 1; i <= XBPlugUiType.values().length; ++i) {
            XBEXPlugUiType type = new XBEXPlugUiType();
            XBPlugUiType uiType = XBPlugUiType.findByDbIndex((int)i);
            type.setName(uiType.getName());
            this.em.persist((Object)type);
            plugUiTypeManager.setItemId(type, uiType.getDbIndex());
        }
        return true;
    }

    @Nonnull
    public XBEXPlugUi createPlugUi() {
        return XBEXUiManager.newInstance(XBEXPlugUi.class);
    }

    public void persistPlugUi(XBCXPlugUi plugUi) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            transaction.begin();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.em.persist((Object)plugUi);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    public void removePlugUi(XBCXPlugUi plugUi) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            transaction.begin();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        XBCXPlugUi removedItem = (XBCXPlugUi)this.em.merge((Object)plugUi);
        this.em.remove((Object)removedItem);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    @Nonnull
    private static <T> T newInstance(Class<T> tClass) {
        try {
            return tClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to create new item", ex);
        }
    }
}

