/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEItem;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBEXLanguage;
import org.exbin.xbup.catalog.entity.XBEXName;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.catalog.entity.manager.XBENodeManager;
import org.exbin.xbup.catalog.entity.manager.XBEXLangManager;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.manager.XBCNodeManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXLangManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEXNameManager
extends XBEDefaultCatalogManager<XBCXName>
implements XBCXNameManager,
Serializable {
    public XBEXNameManager() {
    }

    public XBEXNameManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEXName.class;
    }

    public XBEXName getDefaultItemName(XBCItem item) {
        if (!(item instanceof XBEItem)) {
            return null;
        }
        XBEXLangManager langManager = (XBEXLangManager)this.catalog.getCatalogManager(XBCXLangManager.class);
        return this.getItemName(item, langManager.getDefaultLang());
    }

    public XBEXName getItemName(XBCItem item, XBCXLanguage language) {
        if (!(item instanceof XBEItem)) {
            return null;
        }
        try {
            return (XBEXName)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXName as o WHERE o.item.id = " + ((XBEItem)item).getId() + " AND o.lang.id = " + ((XBEXLanguage)language).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXNameManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCXName> getItemNames(XBCItem item) {
        if (!(item instanceof XBEItem)) {
            return null;
        }
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXName as o WHERE o.item.id = " + ((XBEItem)item).getId()).getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXNameManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void initializeExtension() {
    }

    public String getExtensionName() {
        return "Name Extension";
    }

    public String getDefaultText(XBCItem item) {
        XBEXName name = this.getDefaultItemName(item);
        if (name == null) {
            return "";
        }
        return name.getText();
    }

    @Override
    public boolean initCatalog() {
        XBENodeManager nodeManager = (XBENodeManager)this.catalog.getCatalogManager(XBCNodeManager.class);
        XBENode node = nodeManager.getMainRootNode().orElse(null);
        if (node == null) {
            return false;
        }
        XBEXLanguage defaultLang = ((XBEXLangManager)this.catalog.getCatalogManager(XBCXLangManager.class)).getDefaultLang();
        if (defaultLang == null) {
            return false;
        }
        XBEXName name = new XBEXName();
        name.setItem(node);
        name.setLang(defaultLang);
        name.setText("Root");
        this.em.persist((Object)name);
        return true;
    }
}

