/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.manager.XBCNodeManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBENodeManager
extends XBEDefaultCatalogManager<XBCNode>
implements XBCNodeManager,
Serializable {
    public XBENodeManager() {
    }

    public XBENodeManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBENode.class;
    }

    public List<XBCNode> getSubNodes(XBCNode node) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId()).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBENode getSubNode(XBCNode node, long xbIndex) {
        if (node == null) {
            return null;
        }
        try {
            return (XBENode)this.em.createQuery("SELECT object(o) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getSubNodesCount(XBCNode node) {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public Optional<XBCNode> getMainRootNode() {
        try {
            return Optional.of((XBCNode)this.em.createQuery("SELECT object(n) FROM XBRoot AS o, XBNode AS n WHERE o.node = n AND o.url IS NULL").getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }

    public XBENode findNodeByXBPath(Long[] catalogPath) {
        XBENode node = (XBENode)this.getMainRootNode().get();
        for (Long pathComponent : catalogPath) {
            if ((node = this.getSubNode(node, pathComponent)) != null) continue;
            return null;
        }
        return node;
    }

    public XBENode findParentByXBPath(Long[] catalogPath) {
        if (catalogPath.length == 0) {
            return null;
        }
        XBENode node = (XBENode)this.getMainRootNode().get();
        for (int i = 0; i < catalogPath.length - 1 && (node = this.getSubNode(node, catalogPath[i])) != null; ++i) {
        }
        return node;
    }

    public Long[] getNodeXBPath(XBCNode node) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBENode current = (XBENode)node;
        while (current != null) {
            if (current.getParent().isPresent()) {
                list.add(0, current.getXBIndex());
            }
            current = current.getParent().orElse(null);
        }
        return list.toArray(new Long[list.size()]);
    }

    public XBENode findOwnerByXBPath(Long[] catalogPath) {
        if (catalogPath == null || catalogPath.length == 0) {
            return null;
        }
        XBENode node = (XBENode)this.getMainRootNode().get();
        for (int i = 0; i < catalogPath.length - 1 && (node = this.getSubNode(node, catalogPath[i])) != null; ++i) {
        }
        return node;
    }

    public Long findMaxSubNodeXB(XBCNode node) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (Long)this.em.createQuery("SELECT max(o.xbIndex) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBENode getSubNodeSeq(XBCNode node, long seq) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId() + " ORDER BY o.id");
            query.setFirstResult((int)seq);
            query.setMaxResults(1);
            return (XBENode)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getSubNodesSeq(XBCNode node) {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBNode as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBENodeManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public void removeNodeFully(XBCNode node) {
        long nodeId = node.getId();
        String nodeTreeCond = "(nt.node_id = " + nodeId + " OR nt.owner_id = " + nodeId + ")";
        this.em.createQuery("DELETE * FROM XBXName WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXName.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXDesc WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXDesc.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXStri WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXStri.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXHDoc WHERE EXISTS(SELECT 1 FROM XBXFile fl, XBNodeTree nt WHERE fl.id = XBXHDoc.file_id AND nt.node_id = fl.node_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXHDoc WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXHDoc.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXIcon WHERE EXISTS(SELECT 1 FROM XBXFile fl, XBNodeTree nt WHERE fl.id = XBXFile.file_id AND nt.node_id = fl.node_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXIcon WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXStri.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXPluginUi WHERE EXISTS(SELECT 1 FROM XBPlugin pg, XBXFile fl, XBNodeTree nt WHERE pg.id = XBXPluginUi.plugin_id AND fl.id = pg.pluginfile_id AND nt.node_id = fl.node_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXPluginUi WHERE EXISTS(SELECT 1 FROM XBPlugin pg, XBNodeTree nt WHERE pg.id = XBXPluginUi.plugin_id AND nt.node_id = pg.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXPlugin WHERE EXISTS(SELECT 1 FROM XBXFile fl, XBNodeTree nt WHERE fl.id = XBXPlugin.pluginfile_id AND nt.node_id = fl.node_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXPlugin WHERE EXISTS(SELECT 1 FROM XBNodeTree nt WHERE nt.node_id = XBXPlugin.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBXFile WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE it.id = XBXFile.item_id AND nt.node_id = it.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBConsDef WHERE EXISTS(SELECT 1 FROM XBItem it, XBItem sp, XBNodeTree nt WHERE it.id = XBConsDef.id AND sp.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBJoinDef WHERE EXISTS(SELECT 1 FROM XBItem it, XBItem sp, XBNodeTree nt WHERE it.id = XBJoinDef.id AND sp.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBSpecDef WHERE EXISTS(SELECT 1 FROM XBItem it, XBItem sp, XBNodeTree nt WHERE it.id = XBSpecDef.id AND sp.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBItem WHERE dtype IN ('XBBlockSpec', 'XBGroupSpec', 'XBFormatSpec') AND EXISTS(SELECT 1 FROM XBItem it, XBItem sp, XBNodeTree nt WHERE it.id = XBItem.id AND sp.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBRev WHERE EXISTS(SELECT 1 FROM XBItem it, XBItem rv, XBItem sp, XBNodeTree nt WHERE XBRev.id = rv.id AND rv.owner_id = sp.id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBItem WHERE dtype IN ('XBRev') AND EXISTS(SELECT 1 FROM XBItem it, XBItem sp, XBNodeTree nt WHERE it.id = XBItem.id AND sp.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBSpec WHERE EXISTS(SELECT 1 FROM XBItem it, XBNodeTree nt WHERE XBSpec.id = it.owner_id AND nt.node_id = sp.owner_id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBItem WHERE EXISTS(SELECT 1 FROM XBNodeTree nt WHERE (NOT XBXItem.dType = 'XBNode') AND nt.node_id = XBItem.id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBNode WHERE EXISTS(SELECT 1 FROM XBNodeTree nt WHERE nt.node_id = XBNode.id AND " + nodeTreeCond + ")").executeUpdate();
        this.em.createQuery("DELETE * FROM XBItem WHERE EXISTS(SELECT 1 FROM XBNodeTree nt WHERE nt.node_id = XBItem.id AND " + nodeTreeCond + ")").executeUpdate();
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

