/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.EditorXbupModule;
import org.exbin.framework.editor.xbup.gui.XBDocTreePanel;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBBlockListPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class XBStructurePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBStructurePanel.class);
    private boolean showPreview = false;
    private Mode mode = Mode.BOTH;
    private final XBDocTreePanel treePanel;
    private final XBBlockListPanel blockListPanel;
    private List<BlockViewer> previewBlockViewers = new ArrayList<BlockViewer>();
    private int activeViewerIndex = -1;
    private BlockViewer activeViewer = null;
    private List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private JTextField addressTextField;
    private JToggleButton bothModeToggleButton;
    private JPanel bottomPanel;
    private JPanel headerPanel;
    private JToggleButton listModeToggleButton;
    private JButton nextButton;
    private JPanel previewPanel;
    private JSplitPane previewSplitPane;
    private JButton previousButton;
    private ButtonGroup structureModeButtonGroup;
    private JPanel structurePanel;
    private JToolBar structureToolBar;
    private JToolBar toolBar;
    private JToggleButton treeModeToggleButton;
    private JSplitPane treeSplitPane;
    private JButton upButton;
    private ButtonGroup viewerButtonGroup;

    public XBStructurePanel() {
        this.initComponents();
        this.treePanel = new XBDocTreePanel();
        this.blockListPanel = new XBBlockListPanel();
        this.init();
    }

    private void init() {
        this.setShowPreviewPanel(true);
        this.toolBar.setFloatable(false);
        this.treeSplitPane.setLeftComponent(this.treePanel);
        this.treeSplitPane.setRightComponent(this.blockListPanel);
        this.structureToolBar.setFloatable(false);
        this.structurePanel.add((Component)this.structureToolBar, "South");
        this.structurePanel.add((Component)this.treeSplitPane, "Center");
        this.previewSplitPane.setLeftComponent(this.structurePanel);
        this.previewSplitPane.setRightComponent(this.previewPanel);
        this.add((Component)this.previewSplitPane, "Center");
        this.addItemSelectionListener(item -> {
            Optional<BlockViewer> previewActiveViewer = this.getPreviewActiveViewer();
            if (previewActiveViewer.isPresent()) {
                previewActiveViewer.get().setBlock(item);
            }
        });
        this.treePanel.addItemSelectionListener(item -> {
            if (this.mode == Mode.TREE) {
                this.notifyItemSelectionChanged(item);
            } else if (this.mode == Mode.BOTH) {
                this.blockListPanel.setBlock(item);
            }
        });
        this.blockListPanel.addItemSelectionListener(item -> {
            if (this.mode != Mode.TREE) {
                this.notifyItemSelectionChanged(item);
            }
        });
    }

    public void setApplication(XBApplication application) {
        this.treePanel.setApplication(application);
        EditorXbupModule xbupModule = (EditorXbupModule)application.getModuleRepository().getModuleByInterface(EditorXbupModule.class);
        this.setPopupMenu(xbupModule.getItemPopupMenu());
    }

    public void setCatalog(XBACatalog catalog) {
        this.treePanel.setCatalog(catalog);
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        this.treePanel.setUndoHandler(undoHandler);
    }

    public void postWindowOpened() {
        this.treeSplitPane.setDividerLocation(200);
        this.previewSplitPane.setDividerLocation(400);
    }

    public void addPreviewViewer(BlockViewer blockViewer) {
        int blockViewerIndex = this.previewBlockViewers.size();
        this.previewBlockViewers.add(blockViewer);
        ImageIcon icon = blockViewer.getIcon().orElse(null);
        JToggleButton toggleButton = new JToggleButton(blockViewer.getName(), icon);
        this.viewerButtonGroup.add(toggleButton);
        toggleButton.addActionListener(event -> this.viewerChanged(blockViewerIndex));
        this.bottomPanel.add(toggleButton);
        if (blockViewerIndex == 0) {
            toggleButton.setSelected(true);
            this.viewerChanged(0);
        }
    }

    private void viewerChanged(int blockViewerIndex) {
        if (blockViewerIndex >= 0) {
            BlockViewer blockViewer = this.previewBlockViewers.get(blockViewerIndex);
            if (blockViewer == this.activeViewer) {
                return;
            }
            XBTBlock block = this.getSelectedItem().orElse(null);
            blockViewer.setBlock(block);
            if (this.activeViewer != null) {
                this.previewPanel.remove(this.activeViewer.getComponent());
            }
            this.activeViewer = blockViewer;
            this.previewPanel.add((Component)this.activeViewer.getComponent(), "Center");
            this.previewPanel.revalidate();
            this.previewPanel.repaint();
            this.activeViewerIndex = blockViewerIndex;
        }
    }

    @Nonnull
    public Optional<BlockViewer> getPreviewActiveViewer() {
        return Optional.ofNullable(this.activeViewer);
    }

    public void setAddressText(String addressText) {
        this.addressTextField.setText(addressText);
    }

    private void initComponents() {
        this.structurePanel = new JPanel();
        this.treeSplitPane = new JSplitPane();
        this.previewSplitPane = new JSplitPane();
        this.previewPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.structureToolBar = new JToolBar();
        this.treeModeToggleButton = new JToggleButton();
        this.bothModeToggleButton = new JToggleButton();
        this.listModeToggleButton = new JToggleButton();
        this.structureModeButtonGroup = new ButtonGroup();
        this.viewerButtonGroup = new ButtonGroup();
        this.headerPanel = new JPanel();
        this.toolBar = new JToolBar();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.upButton = new JButton();
        this.addressTextField = new JTextField();
        this.structurePanel.setLayout(new BorderLayout());
        this.previewPanel.setLayout(new BorderLayout());
        this.bottomPanel.setLayout(new FlowLayout(0));
        this.previewPanel.add((Component)this.bottomPanel, "North");
        this.structureModeButtonGroup.add(this.treeModeToggleButton);
        this.treeModeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/view-list-tree-4.png")));
        this.treeModeToggleButton.setEnabled(false);
        this.treeModeToggleButton.setFocusable(false);
        this.treeModeToggleButton.setHorizontalTextPosition(0);
        this.treeModeToggleButton.setVerticalTextPosition(3);
        this.treeModeToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBStructurePanel.this.treeModeToggleButtonActionPerformed(evt);
            }
        });
        this.structureToolBar.add(this.treeModeToggleButton);
        this.structureModeButtonGroup.add(this.bothModeToggleButton);
        this.bothModeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/view-sidetree-3_.png")));
        this.bothModeToggleButton.setSelected(true);
        this.bothModeToggleButton.setEnabled(false);
        this.bothModeToggleButton.setFocusable(false);
        this.bothModeToggleButton.setHorizontalTextPosition(0);
        this.bothModeToggleButton.setVerticalTextPosition(3);
        this.bothModeToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBStructurePanel.this.bothModeToggleButtonActionPerformed(evt);
            }
        });
        this.structureToolBar.add(this.bothModeToggleButton);
        this.structureModeButtonGroup.add(this.listModeToggleButton);
        this.listModeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/view-list-icon-4.png")));
        this.listModeToggleButton.setEnabled(false);
        this.listModeToggleButton.setFocusable(false);
        this.listModeToggleButton.setHorizontalTextPosition(0);
        this.listModeToggleButton.setVerticalTextPosition(3);
        this.listModeToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBStructurePanel.this.listModeToggleButtonActionPerformed(evt);
            }
        });
        this.structureToolBar.add(this.listModeToggleButton);
        this.setLayout(new BorderLayout());
        this.toolBar.setRollover(true);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/arrow-left.png")));
        this.previousButton.setEnabled(false);
        this.toolBar.add(this.previousButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/arrow-right.png")));
        this.nextButton.setEnabled(false);
        this.toolBar.add(this.nextButton);
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/arrow-up.png")));
        this.upButton.setEnabled(false);
        this.toolBar.add(this.upButton);
        this.addressTextField.setEditable(false);
        this.toolBar.add(this.addressTextField);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.add((Component)this.headerPanel, "North");
    }

    private void treeModeToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.TREE);
    }

    private void bothModeToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.BOTH);
    }

    private void listModeToggleButtonActionPerformed(ActionEvent evt) {
        this.setMode(Mode.LIST);
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        if (this.mode == Mode.TREE) {
            return Optional.ofNullable(this.treePanel.getSelectedItem());
        }
        return this.blockListPanel.getSelectedItem();
    }

    public void reportStructureChange(XBTBlock block) {
        this.treePanel.reportStructureChange(block);
    }

    public void addUpdateListener(ActionListener listener) {
        this.treePanel.addUpdateListener(listener);
    }

    public void removeUpdateListener(ActionListener listener) {
        this.treePanel.removeUpdateListener(listener);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBStructurePanel());
    }

    public void updateUndoAvailable() {
        this.firePropertyChange("undoAvailable", false, true);
        this.firePropertyChange("redoAvailable", false, true);
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public void setShowPreviewPanel(boolean showPreview) {
        if (this.showPreview != showPreview) {
            if (this.showPreview) {
                this.remove(this.previewSplitPane);
                this.add((Component)this.structurePanel, "Center");
            } else {
                this.remove(this.structurePanel);
                this.previewSplitPane.setLeftComponent(this.structurePanel);
                this.add((Component)this.previewSplitPane, "Center");
            }
            this.invalidate();
            this.repaint();
            this.showPreview = showPreview;
        }
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        switch (this.mode) {
            case LIST: {
                this.structurePanel.remove(this.blockListPanel);
                break;
            }
            case TREE: {
                this.structurePanel.remove(this.treePanel);
                break;
            }
            case BOTH: {
                this.structurePanel.remove(this.treeSplitPane);
            }
        }
        switch (mode) {
            case LIST: {
                this.structurePanel.add((Component)this.blockListPanel, "Center");
                break;
            }
            case TREE: {
                this.structurePanel.add((Component)this.treePanel, "Center");
                break;
            }
            case BOTH: {
                this.treeSplitPane.setLeftComponent(this.treePanel);
                this.treeSplitPane.setRightComponent(this.blockListPanel);
                this.structurePanel.add((Component)this.treeSplitPane, "Center");
                this.blockListPanel.setBlock((XBTBlock)this.treePanel.getSelectedItem());
            }
        }
        this.structurePanel.revalidate();
        this.structurePanel.repaint();
        this.mode = mode;
    }

    @Nonnull
    public Optional<BlockViewer> getActivePreviewViewer() {
        return Optional.ofNullable(this.activeViewer);
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.treePanel.addPropertyChangeListener(evt -> {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(evt);
            }
        });
        super.addPropertyChangeListener(evt -> {
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(evt);
            }
        });
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.treePanel.setPopupMenu(popupMenu);
        this.blockListPanel.setPopupMenu(popupMenu);
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treePanel.setTreeDocument(treeDocument);
        this.blockListPanel.setTreeDocument(treeDocument);
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    private void notifyItemSelectionChanged(@Nullable XBTBlock item) {
        for (DocumentItemSelectionListener listener : this.itemSelectionListeners) {
            listener.itemSelected(item);
        }
    }

    public void performSelectAll() {
        this.treePanel.performSelectAll();
    }

    public boolean hasSelection() {
        return this.treePanel.hasSelection();
    }

    public void addTreeFocusListener(FocusListener focusListener) {
        this.treePanel.addTreeFocusListener(focusListener);
    }

    public void removeTreeFocusListener(FocusListener focusListener) {
        this.treePanel.removeTreeFocusListener(focusListener);
    }

    public static enum Mode {
        TREE,
        LIST,
        BOTH;

    }
}

