/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBBlockTableModel
extends AbstractTableModel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBBlockTableModel.class);
    private XbupTreeDocument treeDocument;
    private XBTBlock block;
    private final String[] columnNames;
    private final Class[] columnTypes = new Class[]{String.class, String.class, String.class};

    public XBBlockTableModel() {
        this.columnNames = new String[]{"Name", "Block Type", "Size"};
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
    }

    public void setBlock(@Nullable XBTBlock block) {
        this.block = block;
    }

    @Override
    public int getRowCount() {
        if (this.block == null) {
            return 0;
        }
        return this.block.getChildrenCount() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.getTypes()[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            switch (columnIndex) {
                case 0: {
                    return "..";
                }
                case 1: 
                case 2: {
                    return "";
                }
            }
            return "";
        }
        if (this.treeDocument == null) {
            return "";
        }
        XBTBlock childBlock = this.block.getChildAt(rowIndex - 1);
        if (childBlock == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                if (childBlock.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
                    return "Data Block";
                }
                if (childBlock instanceof XBTTreeNode) {
                    return this.treeDocument.getBlockCaption(((XBTTreeNode)childBlock).getBlockDecl());
                }
                return "Node (" + (rowIndex - 1) + ")";
            }
            case 1: {
                if (childBlock.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
                    return "Data";
                }
                return "Node";
            }
            case 2: {
                if (childBlock instanceof XBTTreeNode) {
                    return ((XBTTreeNode)childBlock).getSizeUB();
                }
                return "-";
            }
        }
        return "";
    }

    @Nullable
    public XBTBlock getRowAt(int rowIndex) {
        if (rowIndex == 0) {
            return this.block;
        }
        return this.block.getChildAt(rowIndex - 1);
    }

    @Nonnull
    public Class[] getTypes() {
        return this.columnTypes;
    }
}

