/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class DocumentViewerPanel
extends JPanel {
    private final List<ViewRecord> viewRecords = new ArrayList<ViewRecord>();
    private int activeView = 0;
    private JComponent borderComponent = null;
    private String preferredView = null;
    private boolean updateMode = false;
    private JPanel controlPanel;
    private JPanel headerPanel;
    private JComboBox<String> modeComboBox;
    private JPanel selectionPanel;

    public DocumentViewerPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.modeComboBox.addItemListener(e -> {
            int selectedIndex = this.modeComboBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.switchTo(selectedIndex);
                if (!this.updateMode) {
                    this.preferredView = this.viewRecords.get((int)selectedIndex).name;
                }
            }
        });
    }

    private void switchTo(int index) {
        if (this.activeView >= 0 && this.activeView < this.viewRecords.size()) {
            ViewRecord prevRecord = this.viewRecords.get(this.activeView);
            prevRecord.button.setSelected(false);
            this.remove(prevRecord.component);
        }
        ViewRecord record = this.viewRecords.get(index);
        record.button.setSelected(true);
        this.add((Component)record.component, "Center");
        this.activeView = index;
        this.revalidate();
        this.repaint();
    }

    public void addView(String name, JComponent component) {
        if (this.viewRecords.isEmpty()) {
            this.add((Component)component, "Center");
            if (this.borderComponent != null) {
                this.remove(this.borderComponent);
            }
        }
        ViewRecord record = new ViewRecord(name, component);
        int index = this.viewRecords.size();
        this.viewRecords.add(record);
        record.button = new JToggleButton(name);
        record.button.setSelected(index == 0);
        record.button.addActionListener(e -> {
            this.switchTo(index);
            this.preferredView = this.viewRecords.get((int)index).name;
        });
        this.modeComboBox.addItem(name);
        this.selectionPanel.add(record.button);
    }

    public void viewsAdded() {
        int viewsCount = this.viewRecords.size();
        if (this.preferredView != null) {
            for (int i = 0; i < viewsCount; ++i) {
                ViewRecord viewRecord = this.viewRecords.get(i);
                if (!viewRecord.name.equals(this.preferredView)) continue;
                this.switchTo(i);
            }
        }
        if (viewsCount > 0) {
            this.modeComboBox.setEnabled(true);
        }
        this.updateMode = false;
    }

    public void removeAllViews() {
        if (!this.viewRecords.isEmpty()) {
            if (this.activeView >= 0 && this.activeView < this.viewRecords.size()) {
                ViewRecord prevRecord = this.viewRecords.get(this.activeView);
                this.remove(prevRecord.component);
            }
            this.modeComboBox.removeAllItems();
            this.modeComboBox.setEnabled(false);
            this.selectionPanel.removeAll();
            this.viewRecords.clear();
            if (this.borderComponent != null) {
                this.add((Component)this.borderComponent, "Center");
            }
            this.revalidate();
            this.repaint();
        }
        this.updateMode = true;
    }

    public void setBorderComponent(JComponent component) {
        if (this.borderComponent != null) {
            this.remove(this.borderComponent);
        }
        this.add((Component)component, "Center");
        this.borderComponent = component;
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.selectionPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.modeComboBox = new JComboBox();
        this.setLayout(new BorderLayout());
        this.headerPanel.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.headerPanel.setLayout(new BorderLayout());
        this.selectionPanel.setLayout(new FlowLayout(0));
        this.headerPanel.add((Component)this.selectionPanel, "Center");
        this.controlPanel.setLayout(new FlowLayout(2));
        this.modeComboBox.setEnabled(false);
        this.modeComboBox.setFocusable(false);
        this.controlPanel.add(this.modeComboBox);
        this.headerPanel.add((Component)this.controlPanel, "East");
        this.add((Component)this.headerPanel, "North");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new DocumentViewerPanel());
    }

    @ParametersAreNonnullByDefault
    private static final class ViewRecord {
        String name;
        JToggleButton button;
        JComponent component;

        public ViewRecord(String name, JComponent component) {
            this.name = name;
            this.component = component;
        }
    }
}

