/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.xbup.gui.BlockPropertiesPanel;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XbupSingleEditorProvider
implements XbupEditorProvider,
ClipboardActionsHandler {
    private XBACatalog catalog;
    private PropertyChangeListener propertyChangeListener = null;
    private ClipboardActionsHandler activeHandler;
    private XBApplication application;
    private XBPluginRepository pluginRepository;
    private final List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    private XbupFileHandler activeFile = new XbupFileHandler();
    private boolean devMode = false;
    @Nullable
    private File lastUsedDirectory;

    public XbupSingleEditorProvider() {
        this.activeFile.addItemSelectionListener(block -> this.itemSelectionListeners.forEach(listener -> listener.itemSelected(block)));
    }

    @Nonnull
    public JComponent getEditorComponent() {
        return this.activeFile.getComponent();
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        return Optional.of(this.activeFile);
    }

    @Nonnull
    public Optional<File> getLastUsedDirectory() {
        return Optional.ofNullable(this.lastUsedDirectory);
    }

    public void setLastUsedDirectory(@Nullable File directory) {
        this.lastUsedDirectory = directory;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateRecentFilesList(fileUri, fileType);
    }

    public void setModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
    }

    @Override
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.activeFile.setCatalog(catalog);
    }

    @Override
    public XBApplication getApplication() {
        return this.application;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.activeFile.setApplication(application);
    }

    @Override
    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.activeFile.setPluginRepository(pluginRepository);
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.activeFile.setDevMode(devMode);
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public XBUndoHandler getUndoHandler() {
        return this.activeFile.getUndoHandler();
    }

    @Nonnull
    public String getWindowTitle(String frameTitle) {
        XBTTreeDocument treeDocument = this.activeFile.getDocument();
        String fileName = treeDocument.getFileName();
        if (!"".equals(fileName)) {
            int pos;
            int newpos = 0;
            while ((newpos = fileName.indexOf(File.separatorChar, pos = newpos) + 1) > 0) {
            }
            return fileName.substring(pos) + " - " + frameTitle;
        }
        return frameTitle;
    }

    public void performCut() {
        this.activeHandler.performCut();
    }

    public void performCopy() {
        this.activeHandler.performCopy();
    }

    public void performPaste() {
        this.activeHandler.performPaste();
    }

    public void performDelete() {
        this.activeHandler.performDelete();
    }

    public void performSelectAll() {
        this.activeHandler.performSelectAll();
    }

    public boolean isSelection() {
        return this.activeHandler.isSelection();
    }

    public boolean isEditable() {
        return this.activeHandler.isEditable();
    }

    public boolean canSelectAll() {
        return this.activeHandler.canSelectAll();
    }

    public boolean canPaste() {
        return this.activeHandler.canPaste();
    }

    public boolean canDelete() {
        return this.activeHandler.canDelete();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
        this.clipboardActionsUpdateListener = updateListener;
    }

    public void actionItemProperties() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        BlockPropertiesPanel panel = new BlockPropertiesPanel();
        panel.setApplication(this.application);
        panel.setCatalog(this.catalog);
        panel.setBlock(this.activeFile.getSelectedItem().orElse(null));
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered(null);
    }

    @Override
    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    @Override
    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    public void newFile() {
        this.activeFile.clearFile();
    }

    public void openFile(URI fileUri, FileType fileType) {
        this.activeFile.loadFromFile(fileUri, fileType);
    }

    public void openFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadFromFile(String fileName) throws URISyntaxException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canSave() {
        return true;
    }

    public void saveFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void saveAsFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean releaseFile(FileHandler fileHandler) {
        if (fileHandler.isModified()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            return fileModule.getFileActions().showAskForSaveDialog(fileHandler, null, (UsedDirectoryApi)this);
        }
        return true;
    }

    public boolean releaseAllFiles() {
        return this.releaseFile(this.activeFile);
    }
}

