/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupDocumentViewer;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XbupFileHandler
implements FileHandler {
    private XbupDocumentViewer documentViewer = new XbupDocumentViewer();
    private final XbupTreeDocument treeDocument = new XbupTreeDocument();
    private String title;
    private int id = 0;
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    private URI fileUri = null;
    private FileType fileType = null;

    public XbupFileHandler() {
        this.documentViewer.setTreeDocument(this.treeDocument);
    }

    public XbupFileHandler(int id) {
        this();
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public JComponent getComponent() {
        return this.documentViewer.getComponent();
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        try {
            this.treeDocument.loadFromFile(fileUri, fileType);
            this.documentViewer.setAddressText(fileUri.toASCIIString());
            this.notifyFileChanged();
            this.fileUri = fileUri;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(XbupFileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XbupFileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (XBProcessingException ex) {
            Logger.getLogger(XbupFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public void saveFile() {
        this.saveToFile(this.fileUri, this.fileType);
    }

    public void saveToFile(URI fileUri, FileType fileType) {
        try {
            this.treeDocument.saveToFile(fileUri, fileType);
            this.documentViewer.setAddressText(fileUri.toASCIIString());
            this.fileUri = fileUri;
        }
        catch (IOException ex) {
            Logger.getLogger(XbupFileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    public void clearFile() {
        this.treeDocument.newFile();
        this.documentViewer.setAddressText("");
        this.notifyFileChanged();
    }

    @Nonnull
    public String getTitle() {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastSegment = path.lastIndexOf("/");
            String fileName = lastSegment < 0 ? path : path.substring(lastSegment + 1);
            return fileName == null ? "" : fileName;
        }
        return this.title == null ? "" : this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public Optional<FileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public boolean isModified() {
        return this.treeDocument.wasModified();
    }

    @Nonnull
    public XBTTreeDocument getDocument() {
        return this.treeDocument.getDocument();
    }

    public void loadFromResourcePath(Class<?> classInstance, String resourcePath) {
        try {
            this.treeDocument.loadFromResourcePath(classInstance, resourcePath);
            this.documentViewer.setAddressText("classpath:" + resourcePath);
            this.notifyFileChanged();
            this.treeDocument.getUndoHandler().clear();
        }
        catch (IOException ex) {
            Logger.getLogger(XbupFileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCatalog(XBACatalog catalog) {
        this.treeDocument.setCatalog(catalog);
        this.documentViewer.setCatalog(catalog);
    }

    public void setApplication(XBApplication application) {
        this.treeDocument.setApplication(application);
        this.documentViewer.setApplication(application);
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.documentViewer.setPluginRepository(pluginRepository);
    }

    public void setDevMode(boolean devMode) {
        this.documentViewer.setDevMode(devMode);
    }

    public void notifyFileChanged() {
        this.documentViewer.notifyFileChanged();
    }

    public void postWindowOpened() {
        this.documentViewer.postWindowOpened();
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        return this.documentViewer.getSelectedItem();
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.documentViewer.addItemSelectionListener(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.documentViewer.removeItemSelectionListener(listener);
    }

    @Nonnull
    public XBUndoHandler getUndoHandler() {
        return this.treeDocument.getUndoHandler();
    }

    public void notifyItemModified(XBTTreeNode block) {
        this.notifyFileChanged();
        this.treeDocument.notifyItemModified(block);
    }

    public boolean isSaveSupported() {
        return true;
    }

    public boolean isEditable() {
        return this.documentViewer.isEditable();
    }
}

