/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.BinaryViewer;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.DocumentViewer;
import org.exbin.framework.editor.xbup.viewer.PropertiesViewer;
import org.exbin.framework.editor.xbup.viewer.TextualViewer;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBStructurePanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class StructureViewer
implements BlockViewer {
    private final XBStructurePanel structurePanel = new XBStructurePanel();
    private XBTBlock selectedItem = null;
    private final List<BlockViewer> blockViewers = new ArrayList<BlockViewer>();

    public StructureViewer() {
        this.init();
    }

    private void init() {
        this.blockViewers.add(new DocumentViewer());
        this.blockViewers.add(new PropertiesViewer());
        this.blockViewers.add(new TextualViewer());
        this.blockViewers.add(new BinaryViewer());
        this.structurePanel.addItemSelectionListener(item -> {
            String itemPath;
            this.selectedItem = item;
            if (this.selectedItem != null) {
                if (!this.selectedItem.getParentBlock().isPresent()) {
                    itemPath = "/";
                } else {
                    Optional parentItem;
                    StringBuilder builder = new StringBuilder();
                    XBTBlock pathItem = this.selectedItem;
                    do {
                        if (!(parentItem = pathItem.getParentBlock()).isPresent()) continue;
                        builder.insert(0, "/" + System.identityHashCode(pathItem));
                        pathItem = (XBTBlock)parentItem.get();
                    } while (parentItem.isPresent());
                    itemPath = builder.toString();
                }
            } else {
                itemPath = "";
            }
            this.structurePanel.setAddressText(itemPath);
        });
        for (BlockViewer blockViewer : this.blockViewers) {
            this.structurePanel.addPreviewViewer(blockViewer);
        }
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.structurePanel.setCatalog(catalog);
        this.blockViewers.forEach(blockViewer -> blockViewer.setCatalog(catalog));
    }

    @Override
    public void setApplication(XBApplication application) {
        this.structurePanel.setApplication(application);
        this.blockViewers.forEach(blockViewer -> blockViewer.setApplication(application));
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.blockViewers.forEach(blockViewer -> blockViewer.setPluginRepository(pluginRepository));
    }

    @Override
    @Nonnull
    public String getName() {
        return "Structure";
    }

    @Override
    @Nonnull
    public Optional<ImageIcon> getIcon() {
        return Optional.of(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/list.png")));
    }

    @Override
    public void setBlock(@Nullable XBTBlock block) {
    }

    @Override
    @Nonnull
    public JComponent getComponent() {
        return this.structurePanel;
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.structurePanel.setTreeDocument(treeDocument);
    }

    public void postWindowOpened() {
        this.structurePanel.postWindowOpened();
    }

    public void reportStructureChange(XBTBlock block) {
        this.structurePanel.reportStructureChange(block);
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.structurePanel.addItemSelectionListener(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.structurePanel.removeItemSelectionListener(listener);
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        return this.structurePanel.getSelectedItem();
    }
}

