/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.options.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.xbup.options.impl.ServiceConnectionOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ServiceConnectionPanel
extends JPanel
implements OptionsComponent<ServiceConnectionOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ServiceConnectionPanel.class);
    private OptionsModifiedListener optionsModifiedListener;
    public final String DEFAULT_CATALOG_UPDATE_CONNECTION = "";
    private JCheckBox catalogUpdateConnectionCheckBox;
    private JLabel catalogUpdateConnectionLabel;
    private JTextField catalogUpdateConnectionTextField;
    private JButton defaultCatalogUpdateConnectionButton;
    private JLabel requireRestartLabel;
    private JCheckBox serviceConnectionCheckBox;
    private JLabel serviceConnectionLabel;
    private JTextField serviceConnectionTextField;

    public ServiceConnectionPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(ServiceConnectionOptionsImpl options) {
        if (options.isServiceConnectionAllowed() != this.serviceConnectionCheckBox.isSelected()) {
            this.serviceConnectionCheckBox.doClick();
        }
        String serviceConnection = options.getServiceConnectionUrl().orElse(null);
        this.serviceConnectionTextField.setText(serviceConnection);
        if (options.isCatalogUpdateAllowed() != this.catalogUpdateConnectionCheckBox.isSelected()) {
            this.catalogUpdateConnectionCheckBox.doClick();
        }
        String catalogUpdate = options.getCatalogUpdateUrl().orElse(null);
        this.catalogUpdateConnectionTextField.setText(catalogUpdate);
    }

    public void saveToOptions(ServiceConnectionOptionsImpl options) {
        options.setServiceConnectionAllowed(this.serviceConnectionCheckBox.isSelected());
        options.setServiceConnectionUrl(this.serviceConnectionTextField.getText());
        options.setCatalogUpdateAllowed(this.catalogUpdateConnectionCheckBox.isSelected());
        options.setCatalogUpdateUrl(this.catalogUpdateConnectionTextField.getText());
    }

    private void initComponents() {
        this.serviceConnectionLabel = new JLabel();
        this.catalogUpdateConnectionLabel = new JLabel();
        this.requireRestartLabel = new JLabel();
        this.serviceConnectionCheckBox = new JCheckBox();
        this.serviceConnectionTextField = new JTextField();
        this.catalogUpdateConnectionTextField = new JTextField();
        this.defaultCatalogUpdateConnectionButton = new JButton();
        this.catalogUpdateConnectionCheckBox = new JCheckBox();
        this.serviceConnectionLabel.setText("Catalog connection point (empty for localhost)");
        this.serviceConnectionLabel.setName("serviceConnectionLabel");
        this.catalogUpdateConnectionLabel.setText("Catalog Update Point (empty for central catalog)");
        this.catalogUpdateConnectionLabel.setName("catalogUpdateConnectionLabel");
        this.requireRestartLabel.setText("To apply this application restart is required");
        this.requireRestartLabel.setName("requireRestartLabel");
        this.serviceConnectionCheckBox.setSelected(true);
        this.serviceConnectionCheckBox.setText("Connect to Service");
        this.serviceConnectionCheckBox.setName("serviceConnectionCheckBox");
        this.serviceConnectionTextField.setName("serviceConnectionTextField");
        this.catalogUpdateConnectionTextField.setEnabled(false);
        this.catalogUpdateConnectionTextField.setName("catalogUpdateConnectionTextField");
        this.defaultCatalogUpdateConnectionButton.setText("Default");
        this.defaultCatalogUpdateConnectionButton.setEnabled(false);
        this.defaultCatalogUpdateConnectionButton.setName("defaultCatalogUpdateConnectionButton");
        this.defaultCatalogUpdateConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServiceConnectionPanel.this.defaultCatalogUpdateConnectionButtonActionPerformed(evt);
            }
        });
        this.catalogUpdateConnectionCheckBox.setSelected(true);
        this.catalogUpdateConnectionCheckBox.setText("Built-in Catalog Source (if service not available)");
        this.catalogUpdateConnectionCheckBox.setName("catalogUpdateConnectionCheckBox");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceConnectionCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.requireRestartLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.catalogUpdateConnectionCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceConnectionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.serviceConnectionTextField).addGroup(layout.createSequentialGroup().addComponent(this.catalogUpdateConnectionTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultCatalogUpdateConnectionButton)).addComponent(this.catalogUpdateConnectionLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.serviceConnectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceConnectionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceConnectionTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.catalogUpdateConnectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogUpdateConnectionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.catalogUpdateConnectionTextField, -2, -1, -2).addComponent(this.defaultCatalogUpdateConnectionButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.requireRestartLabel).addContainerGap()));
    }

    private void defaultCatalogUpdateConnectionButtonActionPerformed(ActionEvent evt) {
        this.catalogUpdateConnectionTextField.setText("");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ServiceConnectionPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

