/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.IOException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellEditor;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellRenderer;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.parser_tree.XBATreeParamExtractor;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBCatalogPlugin;
import org.exbin.xbup.plugin.XBPluginRepository;
import org.exbin.xbup.plugin.XBRowEditor;
import org.exbin.xbup.plugin.XBRowEditorCatalogPlugin;

@ParametersAreNonnullByDefault
public class XBPropertyTablePanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private final XBPropertyTableModel tableModel;
    private final XBPropertyTableCellRenderer valueCellRenderer;
    private final TableCellRenderer nameCellRenderer;
    private final XBPropertyTableCellEditor valueCellEditor;
    private XBCXUiService uiService = null;
    private XBPluginRepository pluginRepository = null;
    private Thread propertyThread;
    private final Semaphore valueFillingSemaphore;
    private XBTBlock block;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBPropertyTablePanel.class);
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator7;
    private JScrollPane mainScrollPane;
    private JMenuItem popupCopyMenuItem;
    private JMenuItem popupCutMenuItem;
    private JMenuItem popupDeleteMenuItem;
    private JMenuItem popupItemAddMenuItem;
    private JMenuItem popupItemModifyMenuItem;
    private JMenuItem popupItemOpenMenuItem;
    private JMenuItem popupItemPropertiesMenuItem;
    private JMenuItem popupPasteMenuItem;
    private JMenuItem popupRedoMenuItem;
    private JMenuItem popupSelectAllMenuItem;
    private JMenuItem popupUndoMenuItem;
    private JTable propertiesTable;
    private JPopupMenu propertyPopupMenu;
    private boolean addEnabled = false;
    private boolean undoAvailable = false;

    public XBPropertyTablePanel() {
        this.tableModel = new XBPropertyTableModel();
        this.initComponents();
        TableColumnModel columns = this.propertiesTable.getColumnModel();
        columns.getColumn(0).setPreferredWidth(190);
        columns.getColumn(1).setPreferredWidth(190);
        columns.getColumn(0).setWidth(190);
        columns.getColumn(1).setWidth(190);
        this.nameCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                XBPropertyTableItem tableItem = ((XBPropertyTableModel)table.getModel()).getRow(row);
                component.setToolTipText("(" + tableItem.getDefTypeName() + ") " + tableItem.getValueName());
                return component;
            }
        };
        columns.getColumn(0).setCellRenderer(this.nameCellRenderer);
        this.valueCellRenderer = new XBPropertyTableCellRenderer(null, null);
        columns.getColumn(1).setCellRenderer(this.valueCellRenderer);
        this.valueCellEditor = new XBPropertyTableCellEditor(null, null);
        columns.getColumn(1).setCellEditor(this.valueCellEditor);
        this.propertiesTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(noFocusBorder);
                }
                return component;
            }
        });
        this.propertyThread = null;
        this.valueFillingSemaphore = new Semaphore(1);
    }

    private void initComponents() {
        this.propertyPopupMenu = new JPopupMenu();
        this.popupItemOpenMenuItem = new JMenuItem();
        this.popupItemAddMenuItem = new JMenuItem();
        this.popupItemModifyMenuItem = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.popupUndoMenuItem = new JMenuItem();
        this.popupRedoMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.popupCutMenuItem = new JMenuItem();
        this.popupCopyMenuItem = new JMenuItem();
        this.popupPasteMenuItem = new JMenuItem();
        this.popupDeleteMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.popupSelectAllMenuItem = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.popupItemPropertiesMenuItem = new JMenuItem();
        this.mainScrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.propertyPopupMenu.setName("propertyPopupMenu");
        this.popupItemOpenMenuItem.setText(this.resourceBundle.getString("popupItemOpenMenuItem.text"));
        this.popupItemOpenMenuItem.setToolTipText(this.resourceBundle.getString("popupItemOpenMenuItem.toolTipText"));
        this.popupItemOpenMenuItem.setEnabled(false);
        this.popupItemOpenMenuItem.setName("popupItemOpenMenuItem");
        this.propertyPopupMenu.add(this.popupItemOpenMenuItem);
        this.popupItemAddMenuItem.setText(this.resourceBundle.getString("popupItemAddMenuItem.text"));
        this.popupItemAddMenuItem.setToolTipText(this.resourceBundle.getString("popupItemAddMenuItem.toolTipText"));
        this.popupItemAddMenuItem.setEnabled(false);
        this.popupItemAddMenuItem.setName("popupItemAddMenuItem");
        this.propertyPopupMenu.add(this.popupItemAddMenuItem);
        this.popupItemModifyMenuItem.setText(this.resourceBundle.getString("popupItemModifyMenuItem.text"));
        this.popupItemModifyMenuItem.setToolTipText(this.resourceBundle.getString("popupItemModifyMenuItem.toolTipText"));
        this.popupItemModifyMenuItem.setEnabled(false);
        this.popupItemModifyMenuItem.setName("popupItemModifyMenuItem");
        this.propertyPopupMenu.add(this.popupItemModifyMenuItem);
        this.jSeparator14.setName("jSeparator14");
        this.propertyPopupMenu.add(this.jSeparator14);
        this.popupUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.popupUndoMenuItem.setText(this.resourceBundle.getString("popupUndoMenuItem.text"));
        this.popupUndoMenuItem.setToolTipText(this.resourceBundle.getString("popupUndoMenuItem.toolTipText"));
        this.popupUndoMenuItem.setEnabled(false);
        this.popupUndoMenuItem.setName("popupUndoMenuItem");
        this.propertyPopupMenu.add(this.popupUndoMenuItem);
        this.popupRedoMenuItem.setText(this.resourceBundle.getString("popupRedoMenuItem.text"));
        this.popupRedoMenuItem.setToolTipText(this.resourceBundle.getString("popupRedoMenuItem.toolTipText"));
        this.popupRedoMenuItem.setEnabled(false);
        this.popupRedoMenuItem.setName("popupRedoMenuItem");
        this.propertyPopupMenu.add(this.popupRedoMenuItem);
        this.jSeparator10.setName("jSeparator10");
        this.propertyPopupMenu.add(this.jSeparator10);
        this.popupCutMenuItem.setText("Cut");
        this.popupCutMenuItem.setEnabled(false);
        this.popupCutMenuItem.setName("popupCutMenuItem");
        this.propertyPopupMenu.add(this.popupCutMenuItem);
        this.popupCopyMenuItem.setText("Copy");
        this.popupCopyMenuItem.setEnabled(false);
        this.popupCopyMenuItem.setName("popupCopyMenuItem");
        this.propertyPopupMenu.add(this.popupCopyMenuItem);
        this.popupPasteMenuItem.setText("Paste");
        this.popupPasteMenuItem.setEnabled(false);
        this.popupPasteMenuItem.setName("popupPasteMenuItem");
        this.propertyPopupMenu.add(this.popupPasteMenuItem);
        this.popupDeleteMenuItem.setText("Delete");
        this.popupDeleteMenuItem.setEnabled(false);
        this.popupDeleteMenuItem.setName("popupDeleteMenuItem");
        this.propertyPopupMenu.add(this.popupDeleteMenuItem);
        this.jSeparator7.setName("jSeparator7");
        this.propertyPopupMenu.add(this.jSeparator7);
        this.popupSelectAllMenuItem.setText(this.resourceBundle.getString("popupSelectAllMenuItem.text"));
        this.popupSelectAllMenuItem.setToolTipText(this.resourceBundle.getString("popupSelectAllMenuItem.toolTipText"));
        this.popupSelectAllMenuItem.setEnabled(false);
        this.popupSelectAllMenuItem.setName("popupSelectAllMenuItem");
        this.propertyPopupMenu.add(this.popupSelectAllMenuItem);
        this.jSeparator16.setName("jSeparator16");
        this.propertyPopupMenu.add(this.jSeparator16);
        this.popupItemPropertiesMenuItem.setText(this.resourceBundle.getString("popupItemPropertiesMenuItem.text"));
        this.popupItemPropertiesMenuItem.setToolTipText(this.resourceBundle.getString("popupItemPropertiesMenuItem.toolTipText"));
        this.popupItemPropertiesMenuItem.setEnabled(false);
        this.popupItemPropertiesMenuItem.setName("popupItemPropertiesMenuItem");
        this.propertyPopupMenu.add(this.popupItemPropertiesMenuItem);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.mainScrollPane.setName("mainScrollPane");
        this.propertiesTable.setModel(this.tableModel);
        this.propertiesTable.setComponentPopupMenu(this.propertyPopupMenu);
        this.propertiesTable.setName("propertiesTable");
        this.propertiesTable.setSelectionMode(0);
        this.mainScrollPane.setViewportView(this.propertiesTable);
        this.add((Component)this.mainScrollPane, "Center");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.valueCellEditor.setApplication(application);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBPropertyTablePanel());
    }

    public void setBlock(XBTBlock block) {
        this.block = block;
        this.valueCellRenderer.setBlock(block);
        this.valueCellEditor.setBlock(block);
        new PropertyThread(this, (XBTTreeNode)block).start();
    }

    @Nullable
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.uiService = catalog == null ? null : (XBCXUiService)catalog.getCatalogService(XBCXUiService.class);
        this.valueCellRenderer.setCatalog(catalog);
        this.valueCellEditor.setCatalog(catalog);
    }

    private Thread getPropertyThread() {
        return this.propertyThread;
    }

    private void setPropertyThread(Thread propertyThread) {
        this.propertyThread = propertyThread;
    }

    private Semaphore getValueFillingSemaphore() {
        return this.valueFillingSemaphore;
    }

    @Nullable
    private XBRowEditor getCustomEditor(XBCBlockRev rev) {
        if (rev == null || this.catalog == null) {
            return null;
        }
        XBCXBlockUi blockUi = this.uiService.findUiByPR(rev, XBPlugUiType.ROW_EDITOR, 0L);
        if (blockUi == null) {
            return null;
        }
        XBCXPlugUi plugUi = blockUi.getUi();
        if (plugUi == null) {
            return null;
        }
        XBCXPlugin plugin = plugUi.getPlugin();
        XBCatalogPlugin pluginHandler = this.pluginRepository.getPluginHandler(plugin);
        if (pluginHandler == null) {
            return null;
        }
        return ((XBRowEditorCatalogPlugin)pluginHandler).getRowEditor(plugUi.getMethodIndex());
    }

    public void actionEditSelectAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void actionItemAdd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void actionItemModify() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void actionItemProperties() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void actionItemOpen() {
    }

    public boolean isStub1Enabled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean enabled) {
        boolean old = this.isAddEnabled();
        this.addEnabled = enabled;
        this.firePropertyChange("addEnabled", old, this.isAddEnabled());
    }

    public boolean isUndoAvailable() {
        return this.undoAvailable;
    }

    public void setUndoAvailable(boolean enabled) {
        boolean old = this.isUndoAvailable();
        this.undoAvailable = enabled;
        this.firePropertyChange("undoAvailable", old, this.isUndoAvailable());
    }

    public boolean isRedoAvailable() {
        return false;
    }

    public boolean isEditEnabled() {
        return false;
    }

    public boolean isPasteEnabled() {
        return false;
    }

    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.valueCellRenderer.setPluginRepository(pluginRepository);
        this.valueCellEditor.setPluginRepository(pluginRepository);
    }

    @ParametersAreNonnullByDefault
    private class RowEditorChangeListener
    implements XBRowEditor.ChangeListener {
        private final XBATreeParamExtractor paramExtractor;
        private final int parameterIndex;
        private final XBRowEditor rowEditor;

        private RowEditorChangeListener(XBRowEditor rowEditor, XBATreeParamExtractor paramExtractor, int parameterIndex) {
            this.rowEditor = rowEditor;
            this.paramExtractor = paramExtractor;
            this.parameterIndex = parameterIndex;
        }

        public void valueChanged() {
            this.paramExtractor.setParameterIndex(this.parameterIndex);
            XBPSerialWriter serialWriter = new XBPSerialWriter((XBTEventListener)this.paramExtractor);
            serialWriter.write((XBSerializable)this.rowEditor);
        }
    }

    private class PropertyThread
    extends Thread {
        private final XBPropertyTablePanel propertyPanel;
        private final XBTTreeNode node;

        public PropertyThread(XBPropertyTablePanel propertyPanel, XBTTreeNode node) {
            this.propertyPanel = propertyPanel;
            this.node = node;
        }

        @Override
        public void start() {
            super.start();
            try {
                XBPropertyTablePanel.this.getValueFillingSemaphore().acquire();
                for (int rowIndex = XBPropertyTablePanel.this.tableModel.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
                    XBPropertyTablePanel.this.tableModel.removeRow(rowIndex);
                }
                this.propertyPanel.setPropertyThread(this);
                XBPropertyTablePanel.this.getValueFillingSemaphore().release();
                this.fillPanel();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(XBPropertyTablePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void fillPanel() {
            if (this.node == null) {
                return;
            }
            XBBlockType type = this.node.getBlockType();
            XBBlockDecl decl = this.node.getBlockDecl();
            if (XBPropertyTablePanel.this.propertyThread != this && XBPropertyTablePanel.this.catalog == null) {
                return;
            }
            XBCSpecService specService = (XBCSpecService)XBPropertyTablePanel.this.catalog.getCatalogService(XBCSpecService.class);
            if (decl instanceof XBCBlockDecl) {
                XBCXNameService nameService = (XBCXNameService)XBPropertyTablePanel.this.catalog.getCatalogService(XBCXNameService.class);
                XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
                if (XBPropertyTablePanel.this.propertyThread != this) {
                    return;
                }
                long bindCount = specService.getSpecDefsCount((XBCSpec)spec);
                try {
                    XBPropertyTablePanel.this.getValueFillingSemaphore().acquire();
                    XBATreeParamExtractor paramExtractor = new XBATreeParamExtractor((XBTBlock)this.node, XBPropertyTablePanel.this.catalog);
                    if (this.propertyPanel.getPropertyThread() == this) {
                        int parameterIndex = 0;
                        while ((long)parameterIndex < bindCount) {
                            String rowNameText = "";
                            String typeNameText = "";
                            XBCSpecDef def = specService.getSpecDefByOrder((XBCSpec)spec, (long)parameterIndex);
                            XBRowEditor lineEditor = null;
                            if (def != null) {
                                try {
                                    rowNameText = nameService.getDefaultText((XBCItem)def);
                                    Optional rowRev = def.getTargetRev();
                                    if (rowRev.isPresent()) {
                                        XBCBlockSpec rowSpec = (XBCBlockSpec)((XBCRev)rowRev.get()).getParent();
                                        typeNameText = nameService.getDefaultText((XBCItem)rowSpec);
                                        if (rowNameText.isEmpty()) {
                                            rowNameText = typeNameText;
                                        }
                                        if ((lineEditor = XBPropertyTablePanel.this.getCustomEditor((XBCBlockRev)rowRev.get())) != null) {
                                            paramExtractor.setParameterIndex(parameterIndex);
                                            XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)paramExtractor);
                                            serialReader.read((XBSerializable)lineEditor);
                                            lineEditor.attachChangeListener((XBRowEditor.ChangeListener)new RowEditorChangeListener(lineEditor, paramExtractor, parameterIndex));
                                        }
                                    }
                                }
                                catch (IOException | XBProcessingException ex) {
                                    Logger.getLogger(XBPropertyTablePanel.class.getName()).log(Level.SEVERE, null, ex);
                                    JOptionPane.showMessageDialog(this.propertyPanel, ex.getMessage(), "Exception in property panel", 0);
                                }
                            }
                            XBPropertyTableItem row = new XBPropertyTableItem(def, rowNameText, typeNameText, lineEditor);
                            XBPropertyTablePanel.this.tableModel.addRow(row);
                            ++parameterIndex;
                        }
                    }
                    XBPropertyTablePanel.this.getValueFillingSemaphore().release();
                }
                catch (HeadlessException | InterruptedException ex) {
                    Logger.getLogger(XBPropertyTablePanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

