/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellPanel;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableModel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;
import org.exbin.xbup.plugin.XBRowEditor;

@ParametersAreNonnullByDefault
public class XBPropertyTableCellEditor
extends DefaultCellEditor {
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private final XBTTreeDocument doc;
    private XBTTreeNode node;
    private XBRowEditor rowEditor = null;
    private JComponent rowEditorComponent = null;

    public XBPropertyTableCellEditor(XBTTreeNode node, XBTTreeDocument doc) {
        super(new JTextField());
        super.setClickCountToStart(0);
        this.node = node;
        this.doc = doc;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        XBPropertyTableCellPanel cellPanel;
        XBPropertyTableItem tableItem = ((XBPropertyTableModel)table.getModel()).getRow(row);
        this.rowEditor = tableItem.getRowEditor();
        JComponent jComponent = this.rowEditorComponent = this.rowEditor == null ? null : this.rowEditor.getEditor();
        if (this.rowEditorComponent == null) {
            JComponent defaultComponent = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            defaultComponent.setEnabled(false);
            cellPanel = new XBPropertyTableCellPanel(defaultComponent, this.catalog, this.pluginRepository, this.node, row);
        } else {
            cellPanel = new XBPropertyTableCellPanel(this.rowEditorComponent, this.catalog, this.pluginRepository, this.node, row);
        }
        cellPanel.setApplication(this.application);
        cellPanel.setBackground(table.getSelectionBackground());
        cellPanel.getCellComponent().setBorder(null);
        return cellPanel;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.rowEditor != null) {
            try {
                this.rowEditor.finishEditor();
            }
            catch (Exception ex) {
                Logger.getLogger(XBPropertyTableCellEditor.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this.editorComponent, ex.toString(), "Cell Input", 0);
            }
        }
        return super.stopCellEditing();
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setBlock(XBTBlock block) {
        this.node = (XBTTreeNode)block;
        this.cancelCellEditing();
    }
}

